/*
 ** autoinc.h
 ** Autotools-happy standard library include file
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/** @file
 *  Convenience include file for libnaf.
 */

#ifndef _NAF_AUTOINC_H_
#define _NAF_AUTOINC_H_

#ifdef _NAF_SOURCE_
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <stdint.h>
#include <errno.h>

#include <fcntl.h>
#include <signal.h>
#include <syslog.h>
#include <glob.h>
#include <time.h>
#include <sys/time.h>

#include <fixbuf/public.h>

#ifdef _NAF_SOURCE_
#include <airframe/airutil.h>
#include <airframe/logconfig.h>
#include <airframe/daeconfig.h>
#include <airframe/mio.h>
#include <airframe/mio_config.h>
#include <airframe/mio_stdio.h>
#include <airframe/mio_source_file.h>
#include <airframe/mio_source_udp.h>
#include <airframe/mio_source_tcp.h>
#include <airframe/mio_source_pcap.h>
#include <airframe/mio_sink_file.h>
#include <airframe/mio_sink_udp.h>
#include <airframe/mio_sink_tcp.h>
#include <airframe/mio_sink_multi.h>
#endif

#include <glib.h>
#include <glib/gstdio.h>

#if WITH_DMALLOC
#include <dmalloc.h>
#endif

#endif

