/*
 ** lexcore.h
 ** NAF common parser support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/**
 * @file
 *
 * NAF Core Library Common Lexer API. Used by the aggregation expression parser
 * in nafalize's exparse.c and the common filter implementation defined in
 * filter.h. 
 */

#ifndef _NAF_LEXCORE_H_
#define _NAF_LEXCORE_H_

#include <naf/autoinc.h>

/** NAF lexer token. */
extern char *NAF_SYM_BIN;
/** NAF lexer token. */
extern char *NAF_SYM_UNIFORM;
/** NAF lexer token. */
extern char *NAF_SYM_START;
/** NAF lexer token. */
extern char *NAF_SYM_END;
/** NAF lexer token. */
extern char *NAF_SYM_SEC;
/** NAF lexer token. */
extern char *NAF_SYM_MIN;
/** NAF lexer token. */
extern char *NAF_SYM_HR;
/** NAF lexer token. */
extern char *NAF_SYM_UNIFLOW;
/** NAF lexer token. */
extern char *NAF_SYM_REVEPH;
/** NAF lexer token. */
extern char *NAF_SYM_PERIMETER;
/** NAF lexer token. */
extern char *NAF_SYM_FILTER;
/** NAF lexer token. */
extern char *NAF_SYM_NOT;
/** NAF lexer token. */
extern char *NAF_SYM_IN;
/** NAF lexer token. */
extern char *NAF_SYM_AGGREGATE;
/** NAF lexer token. */
extern char *NAF_SYM_SRCID;
/** NAF lexer token. */
extern char *NAF_SYM_SIP;
/** NAF lexer token. */
extern char *NAF_SYM_DIP;
/** NAF lexer token. */
extern char *NAF_SYM_SP;
/** NAF lexer token. */
extern char *NAF_SYM_DP;
/** NAF lexer token. */
extern char *NAF_SYM_PROTO;
/** NAF lexer token. */
extern char *NAF_SYM_COUNT;
/** NAF lexer token. */
extern char *NAF_SYM_TOTAL;
/** NAF lexer token. */
extern char *NAF_SYM_HOSTS;
/** NAF lexer token. */
extern char *NAF_SYM_PORTS;
/** NAF lexer token. */
extern char *NAF_SYM_FLOWS;
/** NAF lexer token. */
extern char *NAF_SYM_PACKETS;
/** NAF lexer token. */
extern char *NAF_SYM_OCTETS;
/** NAF lexer token. */
extern char *NAF_SYM_LABEL;
/** NAF lexer token. */
extern char *NAF_SYM_REV;
/** NAF lexer token. */
extern char *NAF_SYM_SRC;
/** NAF lexer token. */
extern char *NAF_SYM_DEST;
/** NAF lexer token. */
extern char *NAF_SYM_SORT;
/** NAF lexer token. */
extern char *NAF_SYM_ASC;
/** NAF lexer token. */
extern char *NAF_SYM_DESC;
/** NAF lexer token. */
extern char *NAF_SYM_LIMIT;

/**
 * Initialize a GScanner as a NAF expression lexical scanner over the given 
 * string.
 *
 * @param str string to scan
 * @return a GScanner initialized to read NAF filter and aggregation 
 *         expressions.
 */
GScanner *naf_lex_init(
   char             *str);

/**
 * Initialize a GScanner as a NAF expression lexical scanner over the given 
 * argument list. It is assumed that the argument list has been preprocessed by 
 * the GOption facility to remove any switches; skips over argv[0] which 
 * contains the invocation name of the process.
 *
 * @param argc argument count
 * @param argv argument list
 * @return a GScanner initialized to read NAF filter and aggregation 
 *         expressions.
 */

GScanner *naf_lex_init_argv(
    int              argc,
    char             *argv[]);

#endif
