/*
 ** drv_silk.c
 ** NAF librw (SiLKtools) input driver
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#define _NAF_SOURCE_
#include "drv_silk.h"

/* HACK - can't make automake conditionally build this file for some reason,
   so we'll null it out in the preprocessor if SiLK is not present. */
#if NAF_SILK_ENABLE
#include "nafalize.h"


/* UNHOLY HACK - undefine symbols, unused anyway, to avoid warnings
   that come with including two config.h files. */
#undef PACKAGE
#undef VERSION
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include <rwpack.h>

static char *RCSID __attribute__ ((unused)) = 
    "$Id: drv_silk.c 6585 2007-03-08 00:08:38Z bht $";

static gboolean nafz_silk_open(
    MIOSource           *source,
    void                **dctx,
    GError              **err)
{
    rwIOStruct          *rwin = NULL;
    char                *rwname;
    int                 rwrv;
    
    /* MIO/librw impedence matching */
    if (strcmp(source->name,"-") == 0) {
        rwname = "stdin";
    } else {
        rwname = source->name;
    }
    
    if ((rwrv = rwioCreate(&rwin, "stdin", SK_RWIO_READ)) || 
        (rwrv = rwioOpen(rwin))) {
        rwioPrintLastErr(rwin, rwrv, &skAppPrintErr);
        g_set_error(err, NAF_ERROR_DOMAIN, NAF_ERROR_IO,
                    "Cannot open rw file %s, error %u", source->name, rwrv);
        return FALSE;
    }
    
    *dctx = rwin;
    return TRUE;
}

static gboolean nafz_silk_read(
    MIOSource           *source,
    void                *dctx,
    NAFlowRaw           *flow,
    GError              **err)
{
    rwIOStruct          *rwin = (rwIOStruct *)dctx;
    rwRec               rec;
    int                 rwrv;
    
    /* read a record */
    if ((rwrv = rwioReadRecord(rwin, &rec)) != LIBRW_OK) {
        if (rwin->eofFlag) {
            g_set_error(err, NAF_ERROR_DOMAIN, NAF_ERROR_EOF, "end of file");
            return FALSE;
        } else {
            rwioPrintLastErr(rwin, rwrv, &skAppPrintErr);
            g_set_error(err, NAF_ERROR_DOMAIN, NAF_ERROR_IO,
                        "Cannot read rw record from %s, error %u: %s",
                        source->name, rwrv, strerror(rwin->errnum));
            return FALSE;
        }
    }
    
    /* copy data into raw output record */
    flow->srcid = rec.sID;
    flow->stime = rec.sTime;
    flow->etime = flow->stime + rec.elapsed;
    flow->sip = rec.sIP.ipnum;
    flow->dip = rec.dIP.ipnum;
    flow->sipmask = 32;
    flow->dipmask = 32;
    flow->proto = rec.proto;
    flow->sp = rec.sPort;
    flow->dp = rec.dPort;
    flow->oct = rec.bytes;
    flow->roct = 0;
    flow->pkt = rec.pkts;
    flow->rpkt = 0;
    
    flow->flo = 1;
    flow->rflo = 0;

    return TRUE;
}

static gboolean nafz_silk_close(
    MIOSource           *source,
    void                **dctx,
    GError              **err)
{
    rwIOStruct          *rwin = (rwIOStruct *)*dctx;
    int                 rwrv;
    
    if ((rwrv = rwioClose(rwin)) != LIBRW_OK) {
        g_set_error(err, NAF_ERROR_DOMAIN, NAF_ERROR_IO,
                        "Cannot close rw file %s, error %u: %s",
                        source->name, rwrv, strerror(rwin->errnum));
    }
    rwioDestroy(&rwin);
    *dctx = NULL;
    return rwrv == LIBRW_OK ? TRUE : FALSE;
}

static NAFDriver silk_drv =    {"silk",
                                MIO_T_NULL,
                                (NAFDriverFn)nafz_silk_open, 
                                (NAFDriverReadFn)nafz_silk_read, 
                                (NAFDriverFn)nafz_silk_close };

void nafz_silk_register() {
    nafz_drv_register(&silk_drv);
}

/* end conditional hack */
#endif
