/*
 ** nafalize.h
 ** NAF normalizer and aggregator internal data structures
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/* idem hack */
#ifndef _NAFALIZE_H_
#define _NAFALIZE_H_

#include <naf/nafcore.h>
#include <naf/match.h>
#include <naf/filter.h>
#include <naf/sort.h>

typedef gboolean (*NAFDriverFn)(
    MIOSource           *source,
    void                **dctx,
    GError              **err);

typedef gboolean (*NAFDriverReadFn)(
    MIOSource           *source,
    void                *dctx,
    NAFlowRaw           *flow,
    GError              **err);

typedef struct _NAFDriver {
    char               *name;
    MIOType             type;
    NAFDriverFn         open;
    NAFDriverReadFn     read;
    NAFDriverFn         close;
} NAFDriver;

typedef struct _NafalizeContext {
    NAFAggConfig        *cfg;
    NAFMultiBin         *mtab;
    fBuf_t              **fbuf_ary;
    NAFDriver           *driver;
    void                *rctx;
} NafalizeContext;

/* end idem */
#endif
