/*
 ** naf_indrv.h
 ** nafalize driver-based flow input support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */
 
 /* idem hack */
#ifndef _NAF_INDRV_H_
#define _NAF_INDRV_H_

#include <naf/autoinc.h>
#include <naf/nafcore.h>
#include "nafalize.h"

void nafz_drv_register(
    NAFDriver       *driver);
    
NAFDriver *nafz_drv_lookup(
    const char         *name);

gboolean nafz_open_drv(
    MIOSource               *source,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_process_drv(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_close_drv(
    MIOSource               *source,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);


/* end idem */
#endif
