/*
 ** naf_ipfix.h
 ** NAF IPFIX input support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/* idem hack */
#ifndef _NAF_IPFIX_H_
#define _NAF_IPFIX_H_
#include <naf/autoinc.h>
#include <naf/nafcore.h>

gboolean nafz_open_ipfix_file(
    MIOSource               *source,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_process_ipfix(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_close_ipfix(
    MIOSource               *source,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);


/* end idem */
#endif
