/*
 ** nafz_pcap.h
 ** NAF libpcap input support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2005-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/* idem hack */
#ifndef _NAF_PCAP_H_
#define _NAF_PCAP_H_

#include <naf/autoinc.h>
#include <naf/nafcore.h>

#if NAF_PCAP_ENABLE
#include <pcap.h>

gboolean nafz_open_pcap(
    MIOSource               *source,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_process_pcap(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_close_pcap(
    MIOSource               *source,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_pcap_stats(
    pcap_t              *pcap,
    uint32_t            *recv,
    uint32_t            *drop);

/* end NAF_PCAP_ENABLE */
#endif

/* end idem */
#endif
