/*
 ** nafz_iocom.c
 ** nafalize common flow input/output support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

#define _NAF_SOURCE_
#include <naf/aggregate.h>
#include "nafz_iocom.h"

static char *RCSID __attribute__ ((unused)) = 
    "$Id: nafz_iocom.c 6585 2007-03-08 00:08:38Z bht $";

gboolean nafz_process_flow(
    NafalizeContext     *zctx,
    NAFlowRaw           *flow,
    GError              **err)
{    
    /* Force source ID */
    if (zctx->cfg->srcid) {
        flow->srcid = zctx->cfg->srcid;
    }
    
    /* Add the flow to the match table */
    if (naf_mtab_add_raw(zctx->mtab, flow, err)) {
        /* Flow added. Aggregate and flush if necessary. */
        if (!naf_aggregate(FALSE, zctx->mtab, zctx->cfg, zctx->fbuf_ary, err)) {
            return FALSE;
        }
    } else {
        /* Error adding flow to table; handle it. */
        if (g_error_matches(*err, NAF_ERROR_DOMAIN, NAF_ERROR_HORIZON)) {
            g_warning("%s",(*err)->message);
            g_clear_error(err);
        } else {
            return FALSE;
        }
    }
    
    /* All done */
    return TRUE;
}
