/*
 ** naf_outfile.c
 ** nafalize IPFIX file output support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */
 
#define _NAF_SOURCE_
#include "nafz_outfile.h"

static char *RCSID __attribute__ ((unused)) = 
    "$Id: nafz_outfile.c 6585 2007-03-08 00:08:38Z bht $";

gboolean nafz_open_file_out(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err)
{
    NafalizeContext         *zctx = (NafalizeContext *)vctx;
    fBuf_t                  *fbuf = NULL;
    
    /* open a NAF writer for the file */
    fbuf = zctx->fbuf_ary[0];
    if (!(fbuf = nfWriterForFP(fbuf, mio_fp(sink), 0,
                               &(zctx->cfg->mask[0]), err))) {
        *flags |= (MIO_F_CTL_SINKCLOSE | MIO_F_CTL_ERROR);
        return FALSE;
    }
    zctx->fbuf_ary[0] = fbuf;
        
    return TRUE;
}

gboolean nafz_open_multifile_out(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err)
{
    NafalizeContext         *zctx = (NafalizeContext *)vctx;
    fBuf_t                  *fbuf = NULL;
    uint32_t                mi;
    
    /* open a NAF writer for each output file */
    for (mi = 0; mi < zctx->cfg->fanout; mi++) {
        fbuf = zctx->fbuf_ary[mi];
        if (!(fbuf = nfWriterForFP(fbuf, mio_fp(&mio_smn(sink, mi)), 0,
                                   &(zctx->cfg->mask[mi]), err))) {
            *flags |= (MIO_F_CTL_SINKCLOSE | MIO_F_CTL_ERROR);
            return FALSE;
        }
        zctx->fbuf_ary[mi] = fbuf;
    }
    
    return TRUE;
}

gboolean nafz_close_file_out(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err)
{
    NafalizeContext         *zctx = (NafalizeContext *)vctx;
    uint32_t                mi;

    /* do final message flush */
    for (mi = 0; mi < zctx->cfg->fanout; mi++) {
        if (!nfWriterClose(zctx->fbuf_ary[mi], err)) {
            *flags |= (MIO_F_CTL_SINKCLOSE | MIO_F_CTL_ERROR);
            return FALSE;
        }
    }
    
    return TRUE;
}
