/*
 ** naf_outfile.h
 ** nafalize IPFIX file output support
 **
 ** ------------------------------------------------------------------------
 ** Copyright (C) 2006-2007 Carnegie Mellon University. All Rights Reserved.
 ** ------------------------------------------------------------------------
 ** Authors: Brian Trammell <bht@cert.org>
 ** ------------------------------------------------------------------------
 ** GNU General Public License (GPL) Rights pursuant to Version 2, June 1991
 ** Government Purpose License Rights (GPLR) pursuant to DFARS 252.225-7013
 ** ------------------------------------------------------------------------
 */

/* idem hack */
#ifndef _NAF_OUTFILE_H_
#define _NAF_OUTFILE_H_

#include <naf/autoinc.h>
#include <naf/nafcore.h>
#include "nafalize.h"

gboolean nafz_open_file_out(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_open_multifile_out(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

gboolean nafz_close_file_out(
    MIOSource               *source,
    MIOSink                 *sink,
    void                    *vctx,
    uint32_t                *flags,
    GError                  **err);

/* end idem */
#endif
