#!/usr/bin/env python

import dircache
import install
import os.path
import shutil
import sys
from subprocess import Popen, PIPE

# Get the current revision
revision = "UNKNOWN"
try:
    revision = Popen(["svnversion"], stdout=PIPE).communicate()[0].strip()
    if ':' in revision:
        revision = revision.split(':')[1]
    revision = "r" + revision
except:
    pass

print "Making distribution for %s..." % revision

target = "portal-" + revision
if os.path.exists(target):
    print "Aborting, target path already exists!"
    sys.exit(-1)

print "Exporting revision..."

# Use svn export to get a directory clean of .svn spew
svn_export_rv = Popen(["svn", "export", ".", target]).wait()
if svn_export_rv != 0:
    # Something bad happened--it was reported on stderr
    sys.exit(svn_export_rv)

print "Unpacking documentation..."
class my_options: pass
options = my_options()
options.prefix = target
options.copy_doc = True
options.debug = False
for mod in sorted(dircache.listdir(os.path.join(target, "modules"))):
    install.do_install_module_part(options, mod, "doc")

print "Cleaning house..."

# Now remove some files we don't want going out.  First, this script.
os.unlink(os.path.join(target, "make_dist.py"))

# Now the web doc directory
shutil.rmtree(os.path.join(target, "www-distrib"))

print "Creating archive..."

# And now tar everything up.
tar_rv = Popen(["tar", "-czf", target + ".tar.gz", target]).wait()
if tar_rv != 0:
    # Something bad happened, etc.
    sys.exit(tar_rv)

print "Complete"

sys.exit(0)
