from rave.plugins.decorators import *
from rave.plugins.render_mpl import *
from portal import config

set_font_filename(config.font('Vera'))

@op_file
@typemap(width=int, height=int)
@mime_type('image/png')
def vis_chart_click(out_file_name, width, height):
    render_message(out_file_name, 'Click "Show" to generate', width, height)

@op_file
@typemap()
@mime_type('text/html')
def vis_table_click(out_file_name):
    f = open(out_file_name, 'w')
    f.write('<p style="text-align:center;padding:1em">Click "Show" to generate</p>')
    f.close()

__export__ = { 'support/chart-click': vis_chart_click,
               'support/table-click': vis_table_click }
