import sys
from mod_python import apache, util
from rave.client import fetch_ticket, RaveCommunicationError, RaveTimeoutError
from portal import config
from urllib import urlencode
import traceback

class ProxyConfigurationError(RaveCommunicationError):
    def __init__(self, msg=None):
        preamble = "Rave proxy configuration error"
        if msg:
            msg = "%s: %s" % (preamble, msg)
        else:
            msg = preamble
        RaveCommunicationError.__init__(500, msg)


def get_params(opts):
    "Fetch handler's operational parameters from Apache."
    if opts.has_key('portal.proxy.rave-service'):
        service = opts['portal.proxy.rave-service']
    else:
        raise ProxyConfigurationError(
            "Add 'PythonOption rave-service [url]' to Apache conf")
    if opts.has_key('portal.proxy.timeout'):
        timeout = int(float(opts['portal.proxy.timeout']))
    else:
        timeout = None
    return (service, timeout)


#
# Apache handler function
#

buffer_size = 65536

def handler(req):
    try:
        req.get_basic_auth_pw()
        user = req.user
        service_url, timeout = get_params(req.get_options())
        args = req.args
        if user is not None:
            restrict_all_sensors = False
            # Check for special restrictions
            restrictions = config.url_restrictions(req.path_info)
            for r in restrictions:
                if r == 'restrict-all-sensors':
                    restrict_all_sensors = True
                elif r.startswith('allow:'):
                    group_name = r[6:]
                    if not group_name in config.user_groups(user):
                        req.log_error("Denied user %s access to %s" %
                                      (user, req.path_info))
                        return apache.HTTP_FORBIDDEN
                else:
                    req.log_error("Unrecognized restriction: %s" + r)
                    return apache.HTTP_INTERNAL_SERVER_ERROR
            # Restrict sensors argument
            if args == None:
                args = ''
            parsed_args = util.parse_qsl(args)
            result_args = []
            allowed_sensors = config.allowed_sensors(user)
            allowed_sensors_no_all = [x for x in allowed_sensors if x != 'all']
            for (key, val) in parsed_args:
                if key == 'sensors':
                    sensor_list = [x.strip() for x in val.split(',')]
                    for s in sensor_list:
                        if s not in allowed_sensors:
                            req.log_error("Denied user %s sensor %s on %s" %
                                          (user, s, req.path_info))
                            return apache.HTTP_FORBIDDEN
                    if restrict_all_sensors:
                        result_sensors = []
                        for s in sensor_list:
                            if s == 'all':
                                result_sensors.extend(allowed_sensors_no_all)
                            else:
                                result_sensors.append(s)
                        val = ','.join(list(set(result_sensors)))
                result_args.append((key, val))
            args = urlencode(result_args)
        ticket = fetch_ticket(service_url, req.path_info, args, timeout)
        req.content_type = ticket.get_content_type()
        ticket_in = None
        try:
            ticket_in = ticket.get_stream()
            data = ticket_in.read(buffer_size)
            while data <> "":
                req.write(data)
                data = ticket_in.read(buffer_size)
        finally:
            if ticket_in: ticket_in.close()
    except RaveCommunicationError, e:
        req.log_error("Error proxying RAVE connection: %s" % e.msg)
        return e.code
    except RaveTimeoutError:
        req.log_error("Timeout while fetching %s" % req.path_info)
        return apache.HTTP_NOT_FOUND
    except:
        t, v, tb = sys.exc_info()
        req.log_error("%s while fetching %s?%s: %s\n%s\n" %
                      (str(t), req.path_info, req.args, str(v),
                       traceback.format_tb(tb)))
        return apache.HTTP_INTERNAL_SERVER_ERROR

    return apache.OK

