import threading
import mod_python.util
import mod_python.psp
import portal.config
import os.path
import _apache

vars = threading.local()

def init(req):
    req.get_basic_auth_pw()
    vars.req = req
    vars.id_counter = 0
    vars.include_stack = []
    vars.include_stack.append(req.filename)
    if not hasattr(req, "form"):
        req.form = mod_python.util.FieldStorage(req, keep_blank_values=True)
    if not hasattr(req, "form_valid"):
        req.form_valid = {}
    if not hasattr(req, "form_used"):
        req.form_used = set()
    req.content_type = "text/html; charset=UTF-8"

def get_request():
    return vars.req

def get_new_id(prefix="gen-id-"):
    vars.id_counter += 1
    return prefix + str(vars.id_counter)

class option_group(object):
    __slots__ = 'groups', 'group_items', 'valid_keys'
    def __init__(self, spec=[]):
        if isinstance(spec, option_group):
            self.groups = list(spec.groups)
            self.group_items = dict(spec.group_items)
            self.valid_keys = set(spec.valid_keys)
            return
        self.groups = []
        self.group_items = {}
        self.valid_keys = set()
        for item in spec:
            if isinstance(item, basestring):
                display_name = item
                v = item
            else:
                (display_name, v) = item
            if isinstance(v, basestring):
                # One-line entry
                self.add_entry(None, display_name, v)
            else:
                # Group entry
                group_name = display_name
                for (display_name, k) in v:
                    self.add_entry(group_name, display_name, k)
    def add_group(self, group_name):
        if group_name not in self.groups:
            self.groups.append(group_name)
            self.group_items[group_name] = []
    def add_entry(self, group, display_name, k, i=None):
        self.add_group(group)
        if i == None:
            self.group_items[group].append((display_name, k))
        else:
            self.group_items[group].insert(i, (display_name, k))
        self.valid_keys.add(k)
    def first_key(self):
        (display_name, k) = self.group_items[self.groups[0]][0]
        return k
    def __iter__(self):
        return ((group_name, (item for item in self.group_items[group_name]))
                for group_name in self.groups)
    def __contains__(self, k):
        return k in self.valid_keys

# Exception thrown to indicate that we're dropping out of an included
# PSP template early.
class PortalPSPEarlyCompletion(Exception): pass

def exit_include():
    raise PortalPSPEarlyCompletion()

def include_psp(_filename, **args):
    if _filename is None:
        return ""
    req = get_request()
    # Is it relative?  Make it absolute from the current filename's path
    if not os.path.isabs(_filename):
        base = os.path.dirname(vars.include_stack[-1])
        _filename = os.path.normpath(os.path.join(base, _filename))
        # Next: Is it in a module directory's htdocs or templates?  If so,
        # re-parent it to the unpacked htdocs or templates.
        module_path = portal.config.file("module_path") + "/"
        if _filename.startswith(module_path):
            module_file = _filename[len(module_path):]
            (module_name, part_name, module_file) = module_file.split("/", 2)
            if part_name == "htdocs":
                _filename = portal.config.file("htdocs_path", module_file)
            elif part_name == "templates":
                _filename = portal.config.template(module_file)
    try:
        vars.include_stack.append(_filename)
        try:
            if os.path.isfile(_filename):
                mod_python.psp.PSP(req, filename=_filename, vars=args).run()
            else:
                raise Exception("File not found: " + _filename)
        except PortalPSPEarlyCompletion:
            pass
    finally:
        vars.include_stack.pop()
    return ""

def header(**args):
    return include_psp(portal.config.template("header.psp"), **args)

def control_panel(**args):
    return include_psp(portal.config.template("controls.psp"), **args)

def footer(**args):
    return include_psp(portal.config.template("footer.psp"), **args)
