import portal.psp
import datetime
from rave.plugins.times import iso_date, check_duration

def form_date(k, default="today", optional=False, reject_invalid=False):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    try:
        # Parse failures *or* missing keys result in default
        v = form[k].strip()
        if v == "today":
            v = iso_date(datetime.date.today())
        elif v == "yesterday":
            v = iso_date(datetime.date.today() - datetime.timedelta(days=1))
        elif v == "last week":
            v = iso_date(datetime.date.today() - datetime.timedelta(days=7))
        else:
            v = iso_date(v)
        form_valid[k] = v
        return form_valid[k]
    except KeyError:
        # Form variable isn't there
        if optional:
            form_valid[k] = None
            return None
    except ValueError:
        # Parse failure.
        if reject_invalid:
            raise
    if default == "now":
        v = iso_date(datetime.datetime.now())
    elif default == "today":
        v = iso_date(datetime.date.today())
    elif default == "yesterday":
        v = iso_date(datetime.date.today() - datetime.timedelta(days=1))
    elif default == "last week":
        v = iso_date(datetime.date.today() - datetime.timedelta(days=7))
    else:
        # Will raise ValueError if there's a problem with the default value
        v = iso_date(default)
    form_valid[k] = v
    return v

def form_duration(k, default="P1D", optional=False, reject_invalid=False):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    try:
        check_duration(form[k].strip())
        form_valid[k] = form[k].strip()
        return form_valid[k]
    except KeyError:
        if optional:
            form_valid[k] = None
            return None
    except ValueError:
        if reject_invalid:
            raise
    form_valid[k] = default
    return default

def form_choice(k, spec, default=None, optional=False, reject_invalid=False):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    opts = portal.psp.option_group(spec)
    if default is None:
        default = opts.first_key()
    try:
        if form[k].strip() in opts:
            form_valid[k] = form[k].strip()
            return form_valid[k]
        elif reject_invalid:
            raise
    except KeyError:
        if optional:
            form_valid[k] = None
            return None
    form_valid[k] = default
    return default

def form_flag(k, default=False, optional=True):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    try:
        if form[k].strip() != '':
            form_valid[k] = True
            return True
        else:
            form_valid[k] = False
            return False
    except KeyError:
        if optional:
            form_valid[k] = None
            return None
    form_valid[k] = default
    return default

def form_input(k, default="", optional=False):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    try:
        form_valid[k] = form[k].strip()
        return form_valid[k]
    except KeyError:
        if optional:
            form_valid[k] = None
            return None
    form_valid[k] = default
    return default

def form_valid(k, check_fn, default=None, optional=False):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    try:
        form_valid[k] = check_fn(form[k])
        return form_valid[k]
    except KeyError:
        if optional:
            form_valid[k] = None
            return None
    form_valid[k] = check_fn(default)
    return form_valid[k]

def form_int(k, default=0, optional=False, reject_invalid=False):
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    if k in form_valid:
        return form_valid[k]
    try:
        if form[k].strip() == '':
            raise KeyError()
        form_valid[k] = int(form[k].strip())
        return form_valid[k]
    except KeyError:
        if optional:
            form_valid[k] = None
            return None
    except ValueError:
        if reject_invalid:
            raise
    form_valid[k] = int(default)
    return int(default)

def form_mark_field_used(k):
    form_used = portal.psp.get_request().form_used
    form_used.add(k)

def form_unused_fields():
    form = portal.psp.get_request().form
    form_valid = portal.psp.get_request().form_valid
    form_used = portal.psp.get_request().form_used
    all_form_variables = set(form.keys() + form_valid.keys())
    missing_variables = all_form_variables.difference(form_used)
    for k in missing_variables:
        v = form_valid.get(k, form.get(k, None))
        if v is None or v is False:
            continue        
        yield (k, v)

def form_pluck_field(field):
    form = portal.psp.get_request().form
    value = ''
    if form.has_key(field):
        value = form[field]
        del form[field]
    return value
