import portal.config
import portal.psp
import portal.util
from portal.psp.form import *

def ui_tag_open(_name, **args):
    req = portal.psp.get_request()
    req.write('<')
    req.write(_name)
    for (k, v) in args.iteritems():
        if k.startswith("_"): k = k[1:]
        if v is not False and v is not None:
            # Boolean False or None means: no attribute at all
            if v is True:
                # Boolean True means: attribute="attribute"
                v = k
            req.write(' ')
            req.write(k)
            req.write('=')
            req.write('"')
            req.write(portal.util.encode_attribute(v))
            req.write('"')
    req.write('>')

def ui_tag_empty(_name, **args):
    req = portal.psp.get_request()
    req.write('<')
    req.write(_name)
    for (k, v) in args.iteritems():
        if k.startswith("_"): k = k[1:]
        if v is not False and v is not None:
            # Boolean False means: no attribute at all
            if v is True:
                # Boolean True means: attribute="attribute"
                v = k
            req.write(' ')
            req.write(k)
            req.write('=')
            req.write('"')
            req.write(portal.util.encode_attribute(v))
            req.write('"')
    req.write(' />')    

def ui_rave_chart(_url, _drilldown_url=None, _id=None, **params):
    width = params.get("width",
                       int(portal.config.rendering_option("chart.width")))
    height = params.get("height",
                        int(portal.config.rendering_option("chart.height")))
    params['width'] = width
    params['height'] = height
    _url = portal.util.encode_url_query(_url, params)
    if _id is None:
        _id = portal.psp.get_new_id()
    if _drilldown_url:
        _drilldown_url = portal.util.encode_url_query(_drilldown_url, params)
        return portal.psp.include_psp(
            portal.config.template("chart-drilldown.psp"),
            url=_url, width=width, height=height, drilldown_url=_drilldown_url,
            id=_id)
    else:
        return portal.psp.include_psp(
            portal.config.template("chart.psp"),
            url=_url, width=width, height=height, id=_id)

def ui_rave_table(_url, _id=None, **params):
    _url = portal.util.encode_url_query(_url, params)
    if _id is None:
        _id = portal.psp.get_new_id()
    return portal.psp.include_psp(
        portal.config.template("table.psp"),
        url=_url, id=_id)

def ui_panel_start(panel, title, href=None, icon=None, selected=None, id=None):
    url_root = portal.config.site_option("url_root")
    req = portal.psp.get_request()
    ui_tag_open("div", _class="panel", id=id)
    req.write('<h3>')
    if href is not None and selected != panel:
        ui_tag_open("a", href=('javascript:submit_form_to("' + url_root +
                               '/' + href + '")'),
                    title=title)
    if icon is not None:
        ui_tag_empty("img", _class="icon", src=(url_root + "/" + icon), alt="")
    req.write(portal.util.encode_body(title))
    if href is not None and selected != panel:
        req.write('</a>')
    req.write('</h3>')
    if selected != panel:
        # Short-cut completion of this panel
        req.write('</div>')
        portal.psp.exit_include()
    return ""

def ui_panel_end(hide_show_button=False, advanced_url=None):
    req = portal.psp.get_request()
    if (not hide_show_button) or (advanced_url is not None):
        req.write('<div class="control submit">')
        if not hide_show_button:
            req.write('<input type="submit" name="_show" value="Show" />')
        if advanced_url is not None:
            req.write(' ')
            ui_tag_empty("input", type="button", name="_advanced",
                         value="Advanced...",
                         onclick=('javascript:submit_form_to("' + 
                                  advanced_url + '")'))
        req.write('</div>')
    ui_missing_form_variables()
    req.write('</div>')
    return ""

def ui_control_begin(control_type, id=None):
    req = portal.psp.get_request()
    ui_tag_open("div", _class="control " + control_type, id=id)
    return ""

def ui_control_label(title, target_id=None, id=None):
    req = portal.psp.get_request()
    req.write('<p>')
    ui_tag_open("label", _for=target_id, id=id)
    req.write(portal.util.encode_body(title))
    req.write(':</label></p>')
    return ""

def ui_control_end():
    req = portal.psp.get_request()
    req.write('</div>\n')
    return ""

def ui_calendar(k, title, default="today", optional=False,
                disabled=False, id=None):
    req = portal.psp.get_request()
    v = form_date(k, default, optional)
    if v is None:
        v = ""
    ui_control_begin('calendar', id=id)
    ui_control_label(title, "cal-" + k)
    ui_tag_empty('input', type="text", name=k, value=v, id="cal-"+k,
                 _class="no-transparency format-y-m-d divider-dash",
                 disabled=disabled)
    ui_control_end()
    form_mark_field_used(k)
    return ""

def ui_text(k, title, default="", optional=False, disabled=False, id=None):
    req = portal.psp.get_request()
    v = form_input(k, default, optional)
    if v is None:    
        v = ""
    ui_control_begin('text', id=id)
    field_id = portal.psp.get_new_id()
    ui_control_label(title, field_id)
    ui_tag_empty('input', type="text", name=k, value=v, id=field_id,
                 disabled=disabled)
    ui_control_end()
    form_mark_field_used(k)
    return ""

def ui_pulldown(k, title, spec,
                default=None, optional=False, reject_invalid=False,
                disabled=False, id=None):
    req = portal.psp.get_request()
    v = form_choice(k, spec, default, optional, reject_invalid)
    if id is None:
        id = portal.psp.get_new_id()
    ui_control_begin('pulldown')
    ui_control_label(title, id)
    ui_tag_open("select", name=k, id=id, disabled=disabled)
    opts = portal.psp.option_group(spec)
    for (group_name, items) in opts:
        if group_name is not None:
            ui_tag_open("optgroup", label=group_name)
        for (display_name, item_k) in items:
            ui_tag_open("option", value=item_k, selected=(item_k == v))
            req.write(portal.util.encode_body(display_name))
            req.write("</option>")
        if group_name is not None:
            req.write("</optgroup>")
    req.write('</select>')
    ui_control_end()
    form_mark_field_used(k)
    return ""

def ui_radiogroup(k, title, spec,
                  default=None, optional=False, reject_invalid=False,
                  disabled=False, id=None):
    req = portal.psp.get_request()
    v = form_choice(k, spec, default, optional, reject_invalid)
    ui_control_begin('radiogroup', id=id)
    ui_control_label(title)
    req.write('<ul>')
    opts = portal.psp.option_group(spec)
    for (group_name, items) in opts:
        if group_name is not None:
            req.write('<li><p>')
            req.write(portal.util.encode_body(group_name))
            req.write('</p><ul>')
        for (display_name, item_k) in items:
            id = portal.psp.get_new_id()
            req.write('<li>')
            ui_tag_empty("input", type="radio", name=k, id=id,
                         value=item_k, checked=(item_k == v),
                         disabled=disabled)
            req.write("&#160;")
            ui_tag_open("label", _for=id)
            req.write(portal.util.encode_body(display_name))
            req.write("</label></li>")
        if group_name is not None:
            req.write("</ul></li>")
    req.write("</ul>")
    ui_control_end()
    form_mark_field_used(k)
    return ""

def ui_checkbox(k, label, default=False, optional=False, id=id):
    req = portal.psp.get_request()
    v = form_flag(k, default, optional)
    ui_tag_open("input", type="checkbox", name=k, checked=v, id=id)
    req.write('</input>')
    ui_tag_open("label", _for=id)
    req.write(" %s" % portal.util.encode_body(label))
    req.write("</label>")
    form_mark_field_used(k)
    return ""

def ui_hidden(k, default=None, optional=False, id=id):
    req = portal.psp.get_request()
    v = form_input(k, default, optional)
    ui_tag_open("input", type="hidden", name=k, value=v, id=id)
    req.write('</input>')
    form_mark_field_used(k)
    return ""

def ui_missing_form_variables():
    req = portal.psp.get_request()
    for (k, v) in form_unused_fields():
        # Don't propagate _show and friends
        if not k.startswith("_") and v is not None:
            ui_tag_open("input", type="hidden", name=k, value=v)
            req.write('</input>')
            form_mark_field_used(k)
    return ""
