# coding=utf-8

from rave.plugins.decorators import *
from rave.plugins.times import *
from portal import config

from datetime import timedelta

import urllib

region_list = [
    ("Africa", "Africa"),
    ("Asia", "Asia"),
    ("Europe", "Europe"),
    ("Lat Am", "Latin America and the Carribean"),
    ("N Am", "Northern America"),
    ("Oceania", "Oceania"),
    ("Other", "Other")
]

region_long_name_map = dict(region_list)

region_short_names = ['Africa', 'Asia', 'Europe', 'Lat Am', 
                      'N Am', 'Oceania', 'Other']

subregion_list = [
    ("E Afr", "Eastern Africa"),
    ("M Afr", "Middle Africa"),
    ("N Afr", "Northern Africa"),
    ("S Afr", "Southern Africa"),
    ("W Afr", "Western Africa"),
    ("Carib", "Caribbean"),
    ("C Am", "Central America"),
    ("S Am", "South America"),
    ("N Am", "Northern America"),
    ("C Asia", "Central Asia"),
    ("E Asia", "Eastern Asia"),
    ("S Asia", "Southern Asia"),
    ("SE Asia", "South-Eastern Asia"),
    ("W Asia", "Western Asia"),
    ("E Eur", "Eastern Europe"),
    ("N Eur", "Northern Europe"),
    ("S Eur", "Southern Europe"),
    ("W Eur", "Western Europe"),
    ("Aus/NZ", "Australia and New Zealand"),
    ("Mela", "Melanesia"),
    ("Micro", "Micronesia"),
    ("Poly", "Polynesia"),
    ("Other", "Other")
]

subregion_long_name_map = dict(subregion_list)

subregion_short_names = {
    'Africa': ['E Afr', 'M Afr', 'N Afr', 'S Afr', 'W Afr'],
    'Asia': ['C Asia', 'E Asia', 'S Asia', 'SE Asia', 'W Asia'],
    'Europe': ['E Eur', 'N Eur', 'S Eur', 'W Eur'],
    'Lat Am': ['Carib', 'C Am', 'S Am'],
    'N Am': ['N Am'],
    'Oceania': ['Aus/NZ', 'Mela', 'Micro', 'Poly'],
    'Other': ['Other']
}

regions = {}
regions["E Afr"] =   ["bi","km","dj","er","et","ke","mg","mw","mu","yt","mz",
                      "re","rw","sc","so","ug","tz","zm","zw"]
regions["M Afr"] =   ["ao","cm","cf","td","cg","cd","gq","ga","st"]
regions["N Afr"] =   ["dz","eg","ly","ma","sd","tn","eh"]
regions["S Afr"] =   ["bw","ls","na","za","sz"]
regions["W Afr"] =   ["bj","bf","cv","ci","gm","gh","gn","gw","lr","ml","mr",
                      "ne","ng","sh","sn","sl","tg"]
regions["Carib"] =   ["ai","ag","aw","bs","bb","vg","ky","cu","dm","do","gd",
                      "gp","ht","jm","mq","ms","an","pr","kn","lc","vc","tt",
                      "tc","vi"]
regions["C Am"] =    ["bz","cr","sv","gt","hn","mx","ni","pa"]
regions["S Am"] =    ["ar","bo","br","cl","co","ec","fk","gf","gy","py","pe",
                      "sr","uy","ve"]
regions["N Am"] =    ["bm","ca","gl","pm","us"]
regions["C Asia"] =  ["kz","kg","tj","tm","uz"]
regions["E Asia"] =  ["cn","hk","mo","kp","jp","mn","kr","tw"]
regions["S Asia"] =  ["af","bd","bt","in","ir","mv","np","pk","lk"]
regions["SE Asia"] = ["bn","kh","id","la","my","mm","ph","sg","th","tl","vn"]
regions["W Asia"] =  ["am","az","bh","cy","ge","iq","il","jo","kw","lb","ps",
                      "om","qa","sa","sy","tr","ae","ye"]
regions["E Eur"] =   ["by","bg","cz","hu","pl","md","ro","ru","sk","ua","yu"]
regions["N Eur"] =   ["ax","dk","ee","fo","fi","gg","is","ie","im","je","lv",
                      "lt","no","sj","se","gb"]
regions["S Eur"] =   ["al","ad","ba","hr","gi","gr","va","it","mt","me","pt",
                      "sm","rs","si","es","mk"]
regions["W Eur"] =   ["at","be","fr","de","li","lu","mc","nl","ch","eu"]
regions["Aus/NZ"] =  ["au","nz","nf"]
regions["Mela"] =    ["fj","nc","pg","sb","vu"]
regions["Micro"] =   ["gu","ki","mh","fm","nr","mp","pw"]
regions["Poly"] =    ["as","ck","pf","nu","pn","ws","tk","to","tv","wf"]
regions["Other"] =   ["--","a1","a2"]

regions["Africa"] = \
    (regions["E Afr"] + regions["M Afr"] +
     regions["N Afr"] + regions["S Afr"] +
     regions["W Afr"])
regions["Lat Am"] = \
    (regions["Carib"] + regions["C Am"] +
     regions["S Am"])
regions["Asia"] = \
    (regions["C Asia"] + regions["E Asia"] +
     regions["S Asia"] + regions["SE Asia"] +
     regions["W Asia"])
regions["Europe"] = \
    (regions["E Eur"] + regions["N Eur"] +
     regions["S Eur"] + regions["W Eur"])
regions["Oceania"] = \
    (regions["Aus/NZ"] + regions["Mela"] +
     regions["Micro"] + regions["Poly"])

country_list = [
    ("--", "Unknown"),
    ("a1", "Anonymous Proxies"),
    ("a2", "Satellite Providers"),
    ("af", "Afghanistan"),
    ("ax", "Åland Islands"),
    ("al", "Albania"),
    ("dz", "Algeria"),
    ("as", "American Samoa"),
    ("ad", "Andorra"),
    ("ao", "Angola"),
    ("ai", "Anguilla"),
    ("aq", "Antarctica"),
    ("ag", "Antigua and Barbuda"),
    ("ar", "Argentina"),
    ("am", "Armenia"),
    ("aw", "Aruba"),
    ("au", "Australia"),
    ("at", "Austria"),
    ("az", "Azerbaijan"),
    ("bs", "Bahamas"),
    ("bh", "Bahrain"),
    ("bd", "Bangladesh"),
    ("bb", "Barbados"),
    ("by", "Belarus"),
    ("be", "Belgium"),
    ("bz", "Belize"),
    ("bj", "Benin"),
    ("bm", "Bermuda"),
    ("bt", "Bhutan"),
    ("bo", "Bolivia"),
    ("ba", "Bosnia and Herzegovina"),
    ("bw", "Botswana"),
    ("bv", "Bouvet Island"),
    ("br", "Brazil"),
    ("io", "British Indian Ocean Territory"),
    ("bn", "Brunei Darussalam"),
    ("bg", "Bulgaria"),
    ("bf", "Burkina Faso"),
    ("bi", "Burundi"),
    ("kh", "Cambodia"),
    ("cm", "Cameroon"),
    ("ca", "Canada"),
    ("cv", "Cape Verde"),
    ("ky", "Cayman Islands"),
    ("cf", "Central African Republic"),
    ("td", "Chad"),
    ("cl", "Chile"),
    ("cn", "China"),
    ("cx", "Christmas Island"),
    ("cc", "Cocos (Keeling) Islands"),
    ("co", "Colombia"),
    ("km", "Comoros"),
    ("cg", "Congo"),
    ("cd", "Congo, The Democratic Republic of The"),
    ("ck", "Cook Islands"),
    ("cr", "Costa Rica"),
    ("ci", "Cote d'Ivoire"),
    ("hr", "Croatia"),
    ("cu", "Cuba"),
    ("cy", "Cyprus"),
    ("cz", "Czech Republic"),
    ("dk", "Denmark"),
    ("dj", "Djibouti"),
    ("dm", "Dominica"),
    ("do", "Dominican Republic"),
    ("ec", "Ecuador"),
    ("eg", "Egypt"),
    ("sv", "El Salvador"),
    ("gq", "Equatorial Guinea"),
    ("er", "Eritrea"),
    ("ee", "Estonia"),
    ("et", "Ethiopia"),
    ("eu", "European Union"),
    ("fk", "Falkland Islands (Malvinas)"),
    ("fo", "Faroe Islands"),
    ("fj", "Fiji"),
    ("fi", "Finland"),
    ("fr", "France"),
    ("gf", "French Guiana"),
    ("pf", "French Polynesia"),
    ("tf", "French Southern Territories"),
    ("ga", "Gabon"),
    ("gm", "Gambia"),
    ("ge", "Georgia"),
    ("de", "Germany"),
    ("gh", "Ghana"),
    ("gi", "Gibraltar"),
    ("gr", "Greece"),
    ("gl", "Greenland"),
    ("gd", "Grenada"),
    ("gp", "Guadeloupe"),
    ("gu", "Guam"),
    ("gt", "Guatemala"),
    ("gg", "Guernsey"),
    ("gn", "Guinea"),
    ("gw", "Guinea-Bissau"),
    ("gy", "Guyana"),
    ("ht", "Haiti"),
    ("hm", "Heard Island and Mcdonald Islands"),
    ("va", "Holy See (Vatican City State)"),
    ("hn", "Honduras"),
    ("hk", "Hong Kong"),
    ("hu", "Hungary"),
    ("is", "Iceland"),
    ("in", "India"),
    ("id", "Indonesia"),
    ("ir", "Iran, Islamic Republic of"),
    ("iq", "Iraq"),
    ("ie", "Ireland"),
    ("im", "Isle of Man"),
    ("il", "Israel"),
    ("it", "Italy"),
    ("jm", "Jamaica"),
    ("jp", "Japan"),
    ("je", "Jersey"),
    ("jo", "Jordan"),
    ("kz", "Kazakhstan"),
    ("ke", "Kenya"),
    ("ki", "Kiribati"),
    ("kp", "Korea, Democratic People's Republic of"),
    ("kr", "Korea, Republic of"),
    ("kw", "Kuwait"),
    ("kg", "Kyrgyzstan"),
    ("la", "Lao People's Democratic Republic"),
    ("lv", "Latvia"),
    ("lb", "Lebanon"),
    ("ls", "Lesotho"),
    ("lr", "Liberia"),
    ("ly", "Libyan Arab Jamahiriya"),
    ("li", "Liechtenstein"),
    ("lt", "Lithuania"),
    ("lu", "Luxembourg"),
    ("mo", "Macao"),
    ("mk", "Macedonia, The Former Yugoslav Republic of"),
    ("mg", "Madagascar"),
    ("mw", "Malawi"),
    ("my", "Malaysia"),
    ("mv", "Maldives"),
    ("ml", "Mali"),
    ("mt", "Malta"),
    ("mh", "Marshall Islands"),
    ("mq", "Martinique"),
    ("mr", "Mauritania"),
    ("mu", "Mauritius"),
    ("yt", "Mayotte"),
    ("mx", "Mexico"),
    ("fm", "Micronesia, Federated States of"),
    ("md", "Moldova, Republic of"),
    ("mc", "Monaco"),
    ("mn", "Mongolia"),
    ("me", "Montenegro"),
    ("ms", "Montserrat"),
    ("ma", "Morocco"),
    ("mz", "Mozambique"),
    ("mm", "Myanmar"),
    ("na", "Namibia"),
    ("nr", "Nauru"),
    ("np", "Nepal"),
    ("nl", "Netherlands"),
    ("an", "Netherlands Antilles"),
    ("nc", "New Caledonia"),
    ("nz", "New Zealand"),
    ("ni", "Nicaragua"),
    ("ne", "Niger"),
    ("ng", "Nigeria"),
    ("nu", "Niue"),
    ("nf", "Norfolk Island"),
    ("mp", "Northern Mariana Islands"),
    ("no", "Norway"),
    ("om", "Oman"),
    ("pk", "Pakistan"),
    ("pw", "Palau"),
    ("ps", "Palestinian Territory, Occupied"),
    ("pa", "Panama"),
    ("pg", "Papua New Guinea"),
    ("py", "Paraguay"),
    ("pe", "Peru"),
    ("ph", "Philippines"),
    ("pn", "Pitcairn"),
    ("pl", "Poland"),
    ("pt", "Portugal"),
    ("pr", "Puerto Rico"),
    ("qa", "Qatar"),
    ("re", "Reunion"),
    ("ro", "Romania"),
    ("ru", "Russian Federation"),
    ("rw", "Rwanda"),
    ("sh", "Saint Helena"),
    ("kn", "Saint Kitts and Nevis"),
    ("lc", "Saint Lucia"),
    ("pm", "Saint Pierre and Miquelon"),
    ("vc", "Saint Vincent and the Grenadines"),
    ("ws", "Samoa"),
    ("sm", "San Marino"),
    ("st", "Sao Tome and Principe"),
    ("sa", "Saudi Arabia"),
    ("sn", "Senegal"),
    ("rs", "Serbia"),
    ("sc", "Seychelles"),
    ("sl", "Sierra Leone"),
    ("sg", "Singapore"),
    ("sk", "Slovakia"),
    ("si", "Slovenia"),
    ("sb", "Solomon Islands"),
    ("so", "Somalia"),
    ("za", "South Africa"),
    ("gs", "South Georgia and the South Sandwich Islands"),
    ("es", "Spain"),
    ("lk", "Sri Lanka"),
    ("sd", "Sudan"),
    ("sr", "Suriname"),
    ("sj", "Svalbard and Jan Mayen"),
    ("sz", "Swaziland"),
    ("se", "Sweden"),
    ("ch", "Switzerland"),
    ("sy", "Syrian Arab Republic"),
    ("tw", "Taiwan, Province of China"),
    ("tj", "Tajikistan"),
    ("tz", "Tanzania, United Republic of"),
    ("th", "Thailand"),
    ("tl", "Timor-Leste"),
    ("tg", "Togo"),
    ("tk", "Tokelau"),
    ("to", "Tonga"),
    ("tt", "Trinidad and Tobago"),
    ("tn", "Tunisia"),
    ("tr", "Turkey"),
    ("tm", "Turkmenistan"),
    ("tc", "Turks and Caicos Islands"),
    ("tv", "Tuvalu"),
    ("ug", "Uganda"),
    ("ua", "Ukraine"),
    ("ae", "United Arab Emirates"),
    ("gb", "United Kingdom"),
    ("us", "United States"),
    ("um", "United States Minor Outlying Islands"),
    ("uy", "Uruguay"),
    ("uz", "Uzbekistan"),
    ("vu", "Vanuatu"),
    ("ve", "Venezuela"),
    ("vn", "Viet Nam"),
    ("vg", "Virgin Islands, British"),
    ("vi", "Virgin Islands, U.S."),
    ("wf", "Wallis and Futuna"),
    ("eh", "Western Sahara"),
    ("ye", "Yemen"),
    ("yu", "Yugoslavia"),
    ("zm", "Zambia"),
    ("zw", "Zimbabwe"),
]

country_long_name_map = dict(country_list)

regions['all'] = [cc for (cc, name) in country_list]

country_option_groups = [
    ("Global", [("All", "G-all")]),
    ("Regions", [(display_name, "R-" + name)
                 for (name, display_name) in region_list]),
    ("Sub-Regions", [(display_name, "S-" + name)
                     for (name, display_name) in subregion_list]),
    ("Countries", [(display_name, name)
                   for (name, display_name) in country_list])
]

region_options = [
    (display_name, name) for (name, display_name) in region_list
]

subregion_options = [
    (display_name, name) for (name, display_name) in subregion_list
]

country_options = [
    (display_name, name) for (name, display_name) in country_list
]

def get_countries(cc_list):
    results = set()
    cc_list = get_split_group(cc_list)
    for cc in cc_list:
        if cc == '': cc = 'all'
        if cc.startswith("R-") or cc.startswith("S-") or cc.startswith("G-"):
            cc = cc[2:]
        if cc in regions:
            results = results.union(regions[cc])
        else:
            results = results.union([cc])
    return list(results)

def get_average_size(stime, etime):
    stime = datetime_obj(stime)
    etime = datetime_obj(etime)
    delta = etime - stime
    if delta <= timedelta(days=1):
        return 60*60
    elif delta <= timedelta(days=2):
        return 60*60*2
    elif delta <= timedelta(days=3):
        return 60*60*3
    elif delta <= timedelta(days=4):
        return 60*60*4
    elif delta <= timedelta(days=6):
        return 60*60*6
    elif delta <= timedelta(days=12):
        return 60*60*12
    else:
        return 60*60*24

def get_bin_size(stime, etime):
    stime = datetime_obj(stime)
    etime = datetime_obj(etime)
    delta = etime - stime
    if delta <= timedelta(days=1):
        return 60*5
    elif delta <= timedelta(days=2):
        return 60*10
    elif delta <= timedelta(days=3):
        return 60*15
    elif delta <= timedelta(days=4):
        return 60*20
    elif delta <= timedelta(days=6):
        return 60*30
    elif delta <= timedelta(days=12):
        return 60*60
    elif delta <= timedelta(days=24):
        return 60*60*2
    else:
        return 60*60*3

def get_directions(dirs):
    result = set()
    valid_dirs = ['in', 'out']
    for dir in get_split_group(dirs):
        if dir == 'all':
            return valid_dirs
        if dir in valid_dirs:
            result.add(dir)
    return list(result)

def get_sensors(sensors):
    result = set()
    for sensor_or_group in get_split_group(sensors):
        if sensor_or_group == '': sensor_or_group = 'all'
        result = result.union(config.sensor_group(sensor_or_group))
    return list(result)

@op
def get_protocol_map():
    try:
        f = None
        proto_map = {}
        try:
            f = file('/etc/protocols', 'r')
            for l in f:
                l = l.strip()
                if l <> '' and l[0] <> '#':
                    try:
                        tokens = l.split()
                        proto_map[tokens[1]] = tokens[0]
                    except:
                        pass
            return proto_map
        finally:
            if f:
                f.close()
    except:
        return { '1': 'icmp', '6': 'tcp', '17': 'udp' }

base_service_map = {
    'icmp/0,0': 'echorep',
    'icmp/3,0': 'net-unr',
    'icmp/3,1': 'host-unr',
    'icmp/3,2': 'proto-unr',
    'icmp/3,3': 'port-unr',
    'icmp/3,4': 'needfrag',
    'icmp/3,5': 'srcfail',
    'icmp/3,6': 'net-unk',
    'icmp/3,7': 'host-unk',
    'icmp/3,8': 'isolate',
    'icmp/3,9': 'net-prohib',
    'icmp/3,10': 'host-prohib',
    'icmp/3,11': 'net-tos',
    'icmp/3,12': 'host-tos',
    'icmp/3,13': 'prohib',
    'icmp/3,14': 'host-prec',
    'icmp/3,15': 'prec-cut',
    'icmp/4,0': 'squench',
    'icmp/5,0': 'redir-net',
    'icmp/5,1': 'redir-host',
    'icmp/5,2': 'redir-type-net',
    'icmp/5,3': 'redir-type-host',
    'icmp/6,0': 'alt-addr',
    'icmp/8,0': 'echo',
    'icmp/9,0': 'rtr-adv',
    'icmp/10,0': 'rtr-sel',
    'icmp/11,0': 'ttl-timeout',
    'icmp/11,1': 'frag-timeout',
    'icmp/12,0': 'param-ptr',
    'icmp/12,1': 'param-opt',
    'icmp/12,2': 'param-len',
    'icmp/13,0': 'timest',
    'icmp/14,0': 'timestrep',
    'icmp/15,0': 'inforeq',
    'icmp/16,0': 'inforep',
    'icmp/17,0': 'maskreq',
    'icmp/18,0': 'maskrep',
    'icmp/30,0': 'traceroute-fwd',
    'icmp/30,1': 'traceroute-drop',
    'icmp/31,0': 'conv-unk',
    'icmp/31,1': 'conv-dont',
    'icmp/31,2': 'conv-unk-mand',
    'icmp/31,3': 'conv-uns-opt',
    'icmp/31,4': 'conv-uns-proto',
    'icmp/31,5': 'conv-len',
    'icmp/31,6': 'conv-hdr-len',
    'icmp/31,7': 'conv-high-proto',
    'icmp/31,8': 'conv-port-range',
    'icmp/31,9': 'conv-trans-len',
    'icmp/31,10': 'conv-missing-roll',
    'icmp/31,11': 'conv-unk-trans-mand'
}

for i in xrange(256):
    base_service_map['icmp/32,%d'] = 'mobile-redir'
    base_service_map['icmp/33,%d'] = 'ipv6-where-are-you'
    base_service_map['icmp/34,%d'] = 'ipv6-i-am-here'
    base_service_map['icmp/35,%d'] = 'mobile-req'
    base_service_map['icmp/36,%d'] = 'mobile-rep'
    base_service_map['icmp/39,%d'] = 'skip'
    base_service_map['icmp/40,%d'] = 'photouris'

@op
def get_service_map():
    try:
        f = None
        service_map = dict(base_service_map)
        try:
            f = file('/etc/services', 'r')
            for l in f:
                l = l.strip()
                if l <> '' and l[0] <> '#':
                    try:
                        tokens = l.split()
                        service_name = tokens[0]
                        (port, protocol) = tokens[1].split('/')
                        service_map[protocol + '/' + port] = service_name
                    except:
                        pass
            return service_map
        finally:
            if f:
                f.close()
    except:
        return {}

def get_split_group(g):
    return [x.strip() for x in g.split(',')]

def get_protocols(s):
    result = []
    for x in get_split_group(s):
        if x == 'all' or x == '':
            return []
        try:
            protocol = int(x)
        except:
            raise ValueError("Invalid protocol %s" % repr(x))
        if protocol < 0 or protocol > 255:
            raise ValueError("Invalid protocol %s" % repr(x))
        result.append(protocol)
    return result

def get_tcp_ports(s):
    result = []
    for x in get_split_group(s):
        if x == 'all' or x == '':
            return []
        try:
            port = int(x)
        except:
            raise ValueError("Invalid TCP port %s" % repr(x))
        if port < 0 or port > 65535:
            raise ValueError("Invalid TCP port %s" % repr(x))
        result.append(port)
    return result

def get_udp_ports(s):
    result = []
    for x in get_split_group(s):
        if x == 'all' or x == '':
            return []
        try:
            port = int(x)
        except:
            raise ValueError("Invalid UDP port %s" % repr(x))
        if port < 0 or port > 65535:
            raise ValueError("Invalid UDP port %s" % repr(x))
        result.append(port)
    return result

def get_icmp_type_codes(s):
    result = []
    for x in s.strip().split():
        if x == 'all' or x == '':
            return []
        try:
            [icmp_type, icmp_code] = x.split(',')
        except:
            raise ValueError("Invalid ICMP type-code %s" % repr(x))
        try:
            icmp_type = int(icmp_type)
            icmp_code = int(icmp_code)
        except:
            raise ValueError("Invalid ICMP type-code %s" % repr(x))
        if (icmp_type < 0 or icmp_type > 255 or
            icmp_code < 0 or icmp_code > 255):
            raise ValueError("Invalid ICMP type-code %s" % repr(x))
        result.append("%d-%d" % (icmp_type, icmp_code))
    return result

durations = [("1 day", "P1D"), ("2 days", "P2D"), ("3 days", "P3D"),
             ("1 week", "P7D"), ("2 weeks", "P14D"), ("3 weeks", "P21D"),
             ("1 month", "P1M")]

duration_map = dict((y,x) for (x,y) in durations)

def describe_direction(dir):
    if dir == "in":
        return "Incoming"
    elif dir == "out":
        return "Outgoing"
    elif dir is None:
        return ""
    else:
        return dir

def describe_date_range(sdate, dur):
    if sdate is None:
        return ""
    result = iso_date(sdate).replace("-", "&#8209;")
    if dur <> "P1D" and dur is not None:
        result = duration_map.get(dur, dur).replace(" ", "&#160;") + " starting " + result
    return "for " + result

def describe_sensors(sensors):
    if sensors == "all" or sensors is None:
        return ""
    else:
        return "on " + ", ".join(get_split_group(sensors))

def describe_countries(dir, countries):
    if countries is None:
        return ""
    result_countries = []
    for c in get_split_group(countries):
        if c.startswith("G-"):
            return ""
        if c.startswith("R-"):
            result_countries.append(region_long_name_map[c[2:]])
        elif c.startswith("S-"):
            result_countries.append(subregion_long_name_map[c[2:]])
        elif c in region_long_name_map:
            result_countries.append(region_long_name_map[c])
        elif c in subregion_long_name_map:
            result_countries.append(subregion_long_name_map[c])
        else:
            result_countries.append(country_long_name_map[c])
    if dir == "in":
        dir_name = "from"
    elif dir == "out":
        dir_name = "to"
    else:
        dir_name = "involving"
    return dir_name + " " + ", ".join(result_countries)

def inet_itoa(addr):
    return '.'.join(str((addr>>8*i)&0xFF) for i in [3,2,1,0])

def encode_query(params):
    return '&'.join((urllib.quote_plus(str(k)) + '=' +
                     urllib.quote_plus(str(v), '/:'))
                    for (k, v) in params.iteritems()
                    if v != None)

def encode_url_query(url, params):
    param_string = encode_query(params)
    if param_string == '':
        return url
    else:
        return url + '?' + param_string

def encode_attribute(s):
    return str(s).replace('&', '&amp;').replace('"', '&quot;')

def encode_body(s):
    return str(s).replace('&', '&amp;').replace('<', '&lt;').replace('>', '&gt;')
