from silk import *
from portal.util import *

from rave.plugins.dataset import Dataset
from rave.plugins.db import query
from rave.plugins.decorators import *
from rave.plugins.render_hilbert import *
from rave.plugins.times import *

from datetime import timedelta

from portal.util import *
import portal.config

one_second = timedelta(seconds=1)

width = 500

# For silk: Cache summarized data forever
# Don't do this yet: Need to handle recent data cases.
#set_summary_merged_cache_dur(None)
#set_summary_cache_dur(None)

@op_file
@typemap(sdate=datetime_obj, dur=str, dir=str, sensors=str, countries=str,
         width=int, height=int)
@mime_type('image/png')
def vis_net_map(out_file, sdate, dur, dir, sensors, countries, width, height):
    # Find the best bit size for a square
    edate = add_duration(sdate, dur)
    sdate = silk_hour(sdate)
    edate = silk_hour(edate - one_second)
    sensors = get_sensors(sensors)
    countries = get_countries(countries)
    addrs = []
    flow_counts = []
    if dir == 'out':
        flows = rwfilter(start_date=sdate, end_date=edate,
                         type='out,outweb', sensors=sensors,
                         dcc=countries)
        data = rwtotal(flows, dip_first_24=True, skip_zeroes=True)
        if len(data) > 0:
            addrs = data['dip']
            flow_counts = data['flows']
    else:
        flows = rwfilter(start_date=sdate, end_date=edate,
                         type='in,inweb', sensors=sensors,
                         scc=countries)
        data = rwtotal(flows, sip_first_24=True, skip_zeroes=True)
        if len(data) > 0:
            addrs = data['sip']
            flow_counts = data['flows']
    label_font = portal.config.font("Vera")
    overlay_png = portal.config.module_file(
        "network_map", "etc/hilbert-overlay.png")
    hilbertize_prog = portal.config.module_file(
        "network_map", "libexec/hilbertize")
    render_hilbert(out_file, addrs, flow_counts, label_font=label_font,
                   overlay=overlay_png, hilbertize_program=hilbertize_prog,
                   width=width, height=height)

__export__ = { 'other/net-map': vis_net_map }
