#include <stdio.h>
#include <errno.h>
#include "hilbert.h"

#define BUF_SIZE 1024
#define MAX_DIMENSIONS 16

char buffer[BUF_SIZE];
const char *sep = " \t\n";

void usage(char *name)
{
    fprintf(stderr, "Usage: %s [ bits-per-side [ dimensions ] ]\n", name);
    fprintf(stderr, "   bits-per-side defaults to 12\n");
    fprintf(stderr, "   dimensions defaults to 2 (max 16)\n");
}

int main(int argc, char **argv)
{
    char *buf, *end, *pos;
    size_t l;
    bitmask_t i, p[MAX_DIMENSIONS];
    unsigned int x, y, j;
    int bits = 0;
    int dims = 2;

    if ( argc == 1 ) {
        bits = 12;
    } else if ( (argc == 2) || (argc == 3) ) {
        bits = strtol(argv[1], &end, 10);
        if ( (*argv[1] == '\0') || (*end != '\0') || (bits <= 0) ) {
            fprintf(stderr, "%s: Invalid number of bits per side '%s'\n",
                    argv[0], argv[1]);
            usage(argv[0]);
            return -1;
        }
        if ( argc == 3 ) {
            dims = strtol(argv[2], &end, 10);
            if ( (*argv[2] == '\0') || (*end != '\0') || (dims <= 0) ) {
                fprintf(stderr, "%s: Invalid number of dimensions '%s'\n",
                        argv[0], argv[2]);
                usage(argv[0]);
                return -1;
            }
        }
    } else {
        usage(argv[0]);
        return 0;
    }

    while ( !feof(stdin) ) {
        buf = fgets(buffer, BUF_SIZE, stdin);
        if ( buf == NULL ) {
            if ( feof(stdin) ) {
                return 0;
            } else {
                fprintf(stderr, "Error: %s\n", strerror(errno));
                return -1;
            }
        }
        i = strtoll(buf, &pos, 10);
        if ( buf == pos ) {
            fprintf(stderr, "Error: Couldn't process line\n");
            return -1;
        }
        hilbert_i2c(dims, bits, i, p);
        for ( j = 0; j < dims; j++ ) {
            if ( j ) {
                fprintf(stdout, " ");
            }
            fprintf(stdout, "%-10u", p[j]);
        }
        fprintf(stdout, "%s", pos);
    }
}
