
import sys
import datetime
from rave.plugins.times import sub_duration
from net_map import vis_net_map

import silk
#silk.DEBUG_VERBOSE=True


def precache(dur):
    one_day = timedelta(days=1)
    edate = datetime.datetime.utcnow() + one_day
#   Round edate up to nearest day
    edate = datetime.datetime(edate.year, edate.month, edate.day)
    sdate = sub_duration(edate, dur)
    while edate >= sdate:
        precache_net_map(edate)
        edate = edate - one_day
        

def parse_sensor_option_groups():
    yield ",".join(get_sensors('all'))
    for name, values in sensor_option_groups():
        if name == 'Agencies':
            for agency_name, agency_display_name in values:
                yield ",".join(sensor_group(agency_name))
    for sensor in get_sensors('all'):
        yield sensor
            
                

def precache_net_map(sdate):
    for sgrp in parse_sensor_option_groups():
        for direction in ('in', 'out'):
            vis_net_map(sdate, 'P1D', direction, sgrp, 
                        countries='all',
                        width=600, height=600)

if __name__ == '__main__':
    precache(sys.argv[1])
    
