#!/usr/bin/env python

from rave.plugins.times import silk_hour, iso_datetime, add_duration, sub_duration
from rave.plugins.db import query

from portal.util import *
import portal.config
from tempfile import mkdtemp
import time
import os
import os.path
import sys
import atexit

PSQL_PROGRAM = "psql"

# Find out the database user and DB from portal.config:
from rave.plugins.db import parse_db_url
RAVE_DATABASE_NAME = os.getenv("PORT_DATABASE_RAVE_DB_NAME") or "portdb"
db_info = parse_db_url(portal.config.database(RAVE_DATABASE_NAME))
if db_info['driver'] != 'postgresql':
    raise Exception("Only postgresql is supported by load-portdb.py")

PORT_DATABASE = os.getenv("PORT_DB") or db_info['db'] or 'portdb'
PORT_DATABASE_USER = os.getenv("PORT_DB_USER") or db_info['user'] or 'rave'

if len(sys.argv) == 2:
    hour = sys.argv[1]
else:
    # By default, compute *last* hour
    hour = silk_hour(sub_duration(time.time(), 'PT1H'))

# Create temporary storage directory
temp_dir = mkdtemp()
atexit.register(os.system, ("rm -rf %s" % temp_dir))

def tmp_file(x):
    return os.path.join(temp_dir, x)

def load_hour(h):
    h = silk_hour(h)
    iso_start_time = iso_datetime(h)
    iso_end_time = iso_datetime(add_duration(h, 'PT1H'))

    vars = {
        'in_types':           'in,inweb',
        'out_types':          'out,outweb',
        'silk_hour':          h,
        'table_hour':         h[0:4] + h[5:7] + h[8:10] + 't' + h[11:13],
        'iso_start_time':     iso_start_time,
        'iso_end_time':       iso_end_time,
        'bin_time':           300,
        'tmp_tui_in':         tmp_file('tmp_tui_in.rw'),
        'tmp_tcp_sport_in':   tmp_file('tmp_tcp_sport_in.rwu'),
        'tmp_ui_in':          tmp_file('tmp_ui_in.rw'),
        'tmp_udp_sport_in':   tmp_file('tmp_udp_sport_in.rwu'),
        'tmp_i_in':           tmp_file('tmp_i_in.rw'),
        'all_proto_in':       tmp_file('all_proto_in.rwu'),
        'tcp_sport_in':       tmp_file('tcp_sport_in.rwu'),
        'tcp_dport_in':       tmp_file('tcp_dport_in.rwu'),
        'udp_sport_in':       tmp_file('udp_sport_in.rwu'),
        'udp_dport_in':       tmp_file('udp_dport_in.rwu'),
        'icmp_type_code_in':  tmp_file('icmp_type_code_in.rwu'),
        'tmp_tui_out':        tmp_file('tmp_tui_out.rw'),
        'tmp_tcp_sport_out':  tmp_file('tmp_tcp_sport_out.rwu'),
        'tmp_ui_out':         tmp_file('tmp_ui_out.rw'),
        'tmp_udp_sport_out':  tmp_file('tmp_udp_sport_out.rwu'),
        'tmp_i_out':          tmp_file('tmp_i_out.rw'),
        'all_proto_out':      tmp_file('all_proto_out.rwu'),
        'tcp_sport_out':      tmp_file('tcp_sport_out.rwu'),
        'tcp_dport_out':      tmp_file('tcp_dport_out.rwu'),
        'udp_sport_out':      tmp_file('udp_sport_out.rwu'),
        'udp_dport_out':      tmp_file('udp_dport_out.rwu'),
        'icmp_type_code_out': tmp_file('icmp_type_code_out.rwu'),
        'copy':               '\\copy'
    }

    sh_start_time = time.time()

    os.system("""
    mkfifo %(tmp_tui_in)s
    mkfifo %(tmp_tcp_sport_in)s
    mkfifo %(tmp_ui_in)s
    mkfifo %(tmp_udp_sport_in)s
    mkfifo %(tmp_i_in)s

    rwfilter \\
        --type=%(in_types)s --protocol=1,6,17 --start-date=%(silk_hour)s \\
        --all-destination=stdout --pass-destination=%(tmp_tui_in)s | \\
    rwuniq \\
        --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,scc,protocol,stime | \\
    perl -ple 'chop' > %(all_proto_in)s &

    rwfilter \\
        %(tmp_tui_in)s --protocol=6 \\
        --pass-destination=stdout --fail-destination=%(tmp_ui_in)s | \\
    rwsort --fields=sensor,scc,sport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,scc,sport,stime --output=%(tmp_tcp_sport_in)s \\
        --copy-input=stdout | \\
    rwsort --fields=sensor,scc,dport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,scc,dport,stime | \\
    perl -ple 'chop' > %(tcp_dport_in)s &

    perl -ple 'chop' %(tmp_tcp_sport_in)s > %(tcp_sport_in)s &

    rwfilter \\
        %(tmp_ui_in)s --protocol=17 \\
        --pass-destination=stdout --fail-destination=%(tmp_i_in)s | \\
    rwsort --fields=sensor,scc,sport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,scc,sport,stime --output=%(tmp_udp_sport_in)s \\
        --copy-input=stdout | \\
    rwsort --fields=sensor,scc,dport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,scc,dport,stime | \\
    perl -ple 'chop' > %(udp_dport_in)s &

    perl -ple 'chop' %(tmp_udp_sport_in)s > %(udp_sport_in)s &

    rwsort %(tmp_i_in)s --fields=sensor,scc,icmptypecode,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,scc,icmptypecode,stime | \\
    perl -ple 'chop' > %(icmp_type_code_in)s &

    wait > /dev/null 2>&1

    rm %(tmp_tui_in)s
    rm %(tmp_tcp_sport_in)s
    rm %(tmp_ui_in)s
    rm %(tmp_udp_sport_in)s
    rm %(tmp_i_in)s

    """ % vars)

    sh_end_1_time = time.time()

    os.system("""
    mkfifo %(tmp_tui_out)s
    mkfifo %(tmp_tcp_sport_out)s
    mkfifo %(tmp_ui_out)s
    mkfifo %(tmp_udp_sport_out)s
    mkfifo %(tmp_i_out)s

    rwfilter \\
        --type=%(out_types)s --protocol=1,6,17 --start-date=%(silk_hour)s \\
        --all-destination=stdout --pass-destination=%(tmp_tui_out)s | \\
    rwuniq \\
        --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,dcc,protocol,stime | \\
    perl -ple 'chop' > %(all_proto_out)s &

    rwfilter \\
        %(tmp_tui_out)s --protocol=6 \\
        --pass-destination=stdout --fail-destination=%(tmp_ui_out)s | \\
    rwsort --fields=sensor,dcc,sport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,dcc,sport,stime --output=%(tmp_tcp_sport_out)s \\
        --copy-input=stdout | \\
    rwsort --fields=sensor,dcc,dport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,dcc,dport,stime | \\
    perl -ple 'chop' > %(tcp_dport_out)s &

    perl -ple 'chop' %(tmp_tcp_sport_out)s > %(tcp_sport_out)s &

    rwfilter \\
        %(tmp_ui_out)s --protocol=17 \\
        --pass-destination=stdout --fail-destination=%(tmp_i_out)s | \\
    rwsort --fields=sensor,dcc,sport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,dcc,sport,stime --output=%(tmp_udp_sport_out)s \\
        --copy-input=stdout | \\
    rwsort --fields=sensor,dcc,dport,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,dcc,dport,stime | \\
    perl -ple 'chop' > %(udp_dport_out)s &

    perl -ple 'chop' %(tmp_udp_sport_out)s > %(udp_sport_out)s &

    rwsort %(tmp_i_out)s --fields=sensor,dcc,icmptypecode,stime | \\
    rwuniq \\
        --presorted-input --no-titles --no-columns --column-sep='|' \\
        --bin-time=%(bin_time)s --bytes --packets --flows \\
        --fields=sensor,dcc,icmptypecode,stime | \\
    perl -ple 'chop' > %(icmp_type_code_out)s &

    wait > /dev/null 2>&1

    rm %(tmp_tui_out)s
    rm %(tmp_tcp_sport_out)s
    rm %(tmp_ui_out)s
    rm %(tmp_udp_sport_out)s
    rm %(tmp_i_out)s

    """ % vars)

    sh_end_2_time = time.time()

    db_script = tmp_file('load.sql')
    f = open(db_script, 'w')

    print >>f, ("""
    set maintenance_work_mem = 262144;

    -- Switch to partition schema, so any new tables (partitions) will be in
    -- this part, but we can also refer to the overarching tables.
    set search_path = portdb_partitions, public;

    begin work;
    """)

    # Check which tables exist to be removed
    tables = query(portal.config.database('portdb'), """
        select tablename from pg_tables
          where tablename like ('%%' || %(table_hour)s)
            and schemaname = 'portdb_partitions'
    """, vars)

    for t in tables['tablename']:
        print >>f, ("""
    drop table %(t)s;
        """ % {'t': t})

    print >>f, ("""
    create table all_protocol_in_%(table_hour)s (
        like all_protocol including defaults including constraints
    );
    grant select on all_protocol_in_%(table_hour)s to public;
    alter table all_protocol_in_%(table_hour)s
        alter column direction set default 'in';

    %(copy)s all_protocol_in_%(table_hour)s ( sensor, country, protocol, bin_time, bytes, packets, flows ) from '%(all_proto_in)s' with delimiter '|'
    ;

    create table all_protocol_out_%(table_hour)s (
        like all_protocol including defaults including constraints
    );
    grant select on all_protocol_out_%(table_hour)s to public;
    alter table all_protocol_out_%(table_hour)s
        alter column direction set default 'out';

    %(copy)s all_protocol_out_%(table_hour)s ( sensor, country, protocol, bin_time, bytes, packets, flows ) from '%(all_proto_out)s' with delimiter '|'
    ;

    create table icmp_type_code_in_%(table_hour)s (
        like icmp_type_code including defaults including constraints
    );
    grant select on icmp_type_code_in_%(table_hour)s to public;
    alter table icmp_type_code_in_%(table_hour)s
        alter column direction set default 'in';

    %(copy)s icmp_type_code_in_%(table_hour)s ( sensor, country, icmp_type, icmp_code, bin_time, bytes, packets, flows ) from '%(icmp_type_code_in)s' with delimiter '|'
    ;

    create table icmp_type_code_out_%(table_hour)s (
        like icmp_type_code including defaults including constraints
    );
    grant select on icmp_type_code_out_%(table_hour)s to public;
    alter table icmp_type_code_out_%(table_hour)s
        alter column direction set default 'out';

    %(copy)s icmp_type_code_out_%(table_hour)s ( sensor, country, icmp_type, icmp_code, bin_time, bytes, packets, flows ) from '%(icmp_type_code_out)s' with delimiter '|'
    ;

    create table tcp_dport_in_%(table_hour)s (
        like tcp_dport including defaults including constraints
    );
    grant select on tcp_dport_in_%(table_hour)s to public;
    alter table tcp_dport_in_%(table_hour)s
        alter column direction set default 'in';

    %(copy)s tcp_dport_in_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(tcp_dport_in)s' with delimiter '|'
    ;

    create table tcp_dport_out_%(table_hour)s (
        like tcp_dport including defaults including constraints
    );
    grant select on tcp_dport_out_%(table_hour)s to public;
    alter table tcp_dport_out_%(table_hour)s
        alter column direction set default 'out';

    %(copy)s tcp_dport_out_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(tcp_dport_out)s' with delimiter '|'
    ;

    create table tcp_sport_in_%(table_hour)s (
        like tcp_sport including defaults including constraints
    );
    grant select on tcp_sport_in_%(table_hour)s to public;
    alter table tcp_sport_in_%(table_hour)s
        alter column direction set default 'in';

    %(copy)s tcp_sport_in_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(tcp_sport_in)s' with delimiter '|'
    ;

    create table tcp_sport_out_%(table_hour)s (
        like tcp_sport including defaults including constraints
    );
    grant select on tcp_sport_out_%(table_hour)s to public;
    alter table tcp_sport_out_%(table_hour)s
        alter column direction set default 'out';

    %(copy)s tcp_sport_out_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(tcp_sport_out)s' with delimiter '|'
    ;

    create table udp_dport_in_%(table_hour)s (
        like udp_dport including defaults including constraints
    );
    grant select on udp_dport_in_%(table_hour)s to public;
    alter table udp_dport_in_%(table_hour)s
        alter column direction set default 'in';

    %(copy)s udp_dport_in_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(udp_dport_in)s' with delimiter '|'
    ;

    create table udp_dport_out_%(table_hour)s (
        like udp_dport including defaults including constraints
    );
    grant select on udp_dport_out_%(table_hour)s to public;
    alter table udp_dport_out_%(table_hour)s
        alter column direction set default 'out';

    %(copy)s udp_dport_out_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(udp_dport_out)s' with delimiter '|'
    ;

    create table udp_sport_in_%(table_hour)s (
        like udp_sport including defaults including constraints
    );
    grant select on udp_sport_in_%(table_hour)s to public;
    alter table udp_sport_in_%(table_hour)s
        alter column direction set default 'in';

    %(copy)s udp_sport_in_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(udp_sport_in)s' with delimiter '|'
    ;

    create table udp_sport_out_%(table_hour)s (
        like udp_sport including defaults including constraints
    );
    grant select on udp_sport_out_%(table_hour)s to public;
    alter table udp_sport_out_%(table_hour)s
        alter column direction set default 'out';

    %(copy)s udp_sport_out_%(table_hour)s ( sensor, country, port, bin_time, bytes, packets, flows) from '%(udp_sport_out)s' with delimiter '|'
    ;

    -- Create indices

    create index alL_protocol_in_%(table_hour)s_sensor on
        all_protocol_in_%(table_hour)s ( sensor );
    create index alL_protocol_in_%(table_hour)s_country on
        all_protocol_in_%(table_hour)s ( country );
    create index alL_protocol_in_%(table_hour)s_protocol on
        all_protocol_in_%(table_hour)s ( protocol );
    alter table all_protocol_in_%(table_hour)s
        add constraint all_protocol_in_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table all_protocol_in_%(table_hour)s
        add constraint all_protocol_in_%(table_hour)s_direction_check
            check ( direction = 'in' );
    analyze all_protocol_in_%(table_hour)s;
    create index alL_protocol_out_%(table_hour)s_sensor on
        all_protocol_out_%(table_hour)s ( sensor );
    create index alL_protocol_out_%(table_hour)s_country on
        all_protocol_out_%(table_hour)s ( country );
    create index alL_protocol_out_%(table_hour)s_protocol on
        all_protocol_out_%(table_hour)s ( protocol );
    alter table all_protocol_out_%(table_hour)s
        add constraint all_protocol_out_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table all_protocol_out_%(table_hour)s
        add constraint all_protocol_out_%(table_hour)s_direction_check
            check ( direction = 'out' );
    analyze all_protocol_out_%(table_hour)s;

    create index icmp_type_code_in_%(table_hour)s_sensor on
        icmp_type_code_in_%(table_hour)s ( sensor );
    create index icmp_type_code_in_%(table_hour)s_country on
        icmp_type_code_in_%(table_hour)s ( country );
    create index icmp_type_code_in_%(table_hour)s_type_code on
        icmp_type_code_in_%(table_hour)s ( icmp_type, icmp_code );
    alter table icmp_type_code_in_%(table_hour)s
        add constraint icmp_type_code_in_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table icmp_type_code_in_%(table_hour)s
        add constraint icmp_type_code_in_%(table_hour)s_direction_check
            check ( direction = 'in' );
    analyze icmp_type_code_in_%(table_hour)s;
    create index icmp_type_code_out_%(table_hour)s_sensor on
        icmp_type_code_out_%(table_hour)s ( sensor );
    create index icmp_type_code_out_%(table_hour)s_country on
        icmp_type_code_out_%(table_hour)s ( country );
    create index icmp_type_code_out_%(table_hour)s_type_code on
        icmp_type_code_out_%(table_hour)s ( icmp_type, icmp_code );
    alter table icmp_type_code_out_%(table_hour)s
        add constraint icmp_type_code_out_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table icmp_type_code_out_%(table_hour)s
        add constraint icmp_type_code_out_%(table_hour)s_direction_check
            check ( direction = 'out' );
    analyze icmp_type_code_out_%(table_hour)s;

    create index tcp_dport_in_%(table_hour)s_sensor on
        tcp_dport_in_%(table_hour)s ( sensor );
    create index tcp_dport_in_%(table_hour)s_country on
        tcp_dport_in_%(table_hour)s ( country );
    create index tcp_dport_in_%(table_hour)s_port on
        tcp_dport_in_%(table_hour)s ( port );
    alter table tcp_dport_in_%(table_hour)s
        add constraint tcp_dport_in_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table tcp_dport_in_%(table_hour)s
        add constraint tcp_dport_in_%(table_hour)s_direction_check
            check ( direction = 'in' );
    analyze tcp_dport_in_%(table_hour)s;
    create index tcp_dport_out_%(table_hour)s_sensor on
        tcp_dport_out_%(table_hour)s ( sensor );
    create index tcp_dport_out_%(table_hour)s_country on
        tcp_dport_out_%(table_hour)s ( country );
    create index tcp_dport_out_%(table_hour)s_port on
        tcp_dport_out_%(table_hour)s ( port );
    alter table tcp_dport_out_%(table_hour)s
        add constraint tcp_dport_out_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table tcp_dport_out_%(table_hour)s
        add constraint tcp_dport_out_%(table_hour)s_direction_check
            check ( direction = 'out' );
    analyze tcp_dport_out_%(table_hour)s;

    create index tcp_sport_in_%(table_hour)s_sensor on
        tcp_sport_in_%(table_hour)s ( sensor );
    create index tcp_sport_in_%(table_hour)s_country on
        tcp_sport_in_%(table_hour)s ( country );
    create index tcp_sport_in_%(table_hour)s_port on
        tcp_sport_in_%(table_hour)s ( port );
    alter table tcp_sport_in_%(table_hour)s
        add constraint tcp_sport_in_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table tcp_sport_in_%(table_hour)s
        add constraint tcp_sport_in_%(table_hour)s_direction_check
            check ( direction = 'in' );
    analyze tcp_sport_in_%(table_hour)s;
    create index tcp_sport_out_%(table_hour)s_sensor on
        tcp_sport_out_%(table_hour)s ( sensor );
    create index tcp_sport_out_%(table_hour)s_country on
        tcp_sport_out_%(table_hour)s ( country );
    create index tcp_sport_out_%(table_hour)s_port on
        tcp_sport_out_%(table_hour)s ( port );
    alter table tcp_sport_out_%(table_hour)s
        add constraint tcp_sport_out_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table tcp_sport_out_%(table_hour)s
        add constraint tcp_sport_out_%(table_hour)s_direction_check
            check ( direction = 'out' );
    analyze tcp_sport_out_%(table_hour)s;

    create index udp_dport_in_%(table_hour)s_sensor on
        udp_dport_in_%(table_hour)s ( sensor );
    create index udp_dport_in_%(table_hour)s_country on
        udp_dport_in_%(table_hour)s ( country );
    create index udp_dport_in_%(table_hour)s_port on
        udp_dport_in_%(table_hour)s ( port );
    alter table udp_dport_in_%(table_hour)s
        add constraint udp_dport_in_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table udp_dport_in_%(table_hour)s
        add constraint udp_dport_in_%(table_hour)s_direction_check
            check ( direction = 'in' );
    analyze udp_dport_in_%(table_hour)s;
    create index udp_dport_out_%(table_hour)s_sensor on
        udp_dport_out_%(table_hour)s ( sensor );
    create index udp_dport_out_%(table_hour)s_country on
        udp_dport_out_%(table_hour)s ( country );
    create index udp_dport_out_%(table_hour)s_port on
        udp_dport_out_%(table_hour)s ( port );
    alter table udp_dport_out_%(table_hour)s
        add constraint udp_dport_out_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table udp_dport_out_%(table_hour)s
        add constraint udp_dport_out_%(table_hour)s_direction_check
            check ( direction = 'out' );
    analyze udp_dport_out_%(table_hour)s;

    create index udp_sport_in_%(table_hour)s_sensor on
        udp_sport_in_%(table_hour)s ( sensor );
    create index udp_sport_in_%(table_hour)s_country on
        udp_sport_in_%(table_hour)s ( country );
    create index udp_sport_in_%(table_hour)s_port on
        udp_sport_in_%(table_hour)s ( port );
    alter table udp_sport_in_%(table_hour)s
        add constraint udp_sport_in_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table udp_sport_in_%(table_hour)s
        add constraint udp_sport_in_%(table_hour)s_direction_check
            check ( direction = 'in' );
    analyze udp_sport_in_%(table_hour)s;
    create index udp_sport_out_%(table_hour)s_sensor on
        udp_sport_out_%(table_hour)s ( sensor );
    create index udp_sport_out_%(table_hour)s_country on
        udp_sport_out_%(table_hour)s ( country );
    create index udp_sport_out_%(table_hour)s_port on
        udp_sport_out_%(table_hour)s ( port );
    alter table udp_sport_out_%(table_hour)s
        add constraint udp_sport_out_%(table_hour)s_date_check
            check ( bin_time >= '%(iso_start_time)s' and
                    bin_time < '%(iso_end_time)s' );
    alter table udp_sport_out_%(table_hour)s
        add constraint udp_sport_out_%(table_hour)s_direction_check
            check ( direction = 'out' );
    analyze udp_sport_out_%(table_hour)s;

    alter table all_protocol_in_%(table_hour)s inherit all_protocol;
    alter table all_protocol_out_%(table_hour)s inherit all_protocol;
    alter table icmp_type_code_in_%(table_hour)s inherit icmp_type_code;
    alter table icmp_type_code_out_%(table_hour)s inherit icmp_type_code;
    alter table tcp_dport_in_%(table_hour)s inherit tcp_dport;
    alter table tcp_dport_out_%(table_hour)s inherit tcp_dport;
    alter table tcp_sport_in_%(table_hour)s inherit tcp_sport;
    alter table tcp_sport_out_%(table_hour)s inherit tcp_sport;
    alter table udp_dport_in_%(table_hour)s inherit udp_dport;
    alter table udp_dport_out_%(table_hour)s inherit udp_dport;
    alter table udp_sport_in_%(table_hour)s inherit udp_sport;
    alter table udp_sport_out_%(table_hour)s inherit udp_sport;

    commit work;

    """ % vars)
    f.close()

    sql_start_time = time.time()
    os.system("%s -U %s %s -q -f %s" % (PSQL_PROGRAM, PORT_DATABASE_USER,
                                        PORT_DATABASE, db_script))
    sql_end_time = time.time()

load_hour(hour)
