import sys
import os
import os.path
import errno
import copy
from time import mktime, strftime
from datetime import datetime, timedelta

from rave.plugins.decorators import *
from rave.plugins.times import datetime_obj, add_duration, sub_duration
from rave.plugins.render_mpl import render_boxplot, set_font_filename

from portal.util import *
import portal.config

set_font_filename(portal.config.font('Vera'))

def parsefile(fname):
    f = open(fname, 'r')
    try:
    #   Throw away first line
        f.readline()
        curr_size = None

        deltas = []
        for line in f.readlines():
            nowtime, mtime, etime, size = line.split(" ")
            size = int(size)
#            if curr_size is None:
#                curr_size = size
        #   ignore 
            if etime.startswith("----"):
                continue
            if size != curr_size:
                nowtime = int(mktime(datetime_obj(nowtime).utctimetuple()))
                #mtime = int(mktime(datetime_obj(mtime).utctimetuple()))
                etime = int(mktime(datetime_obj(etime).utctimetuple()))
                deltas.append(nowtime - etime)
                #deltas.append(mtime - etime)
                curr_size = size
        return deltas
    finally:
        f.close()

@op
@typemap(sensor=str, hour=datetime_obj)
#@expires(duration_strategy("1m")) # one minute -- short for testing
def gen_data_hour(sensor, hour):
    hour_directory = strftime("%Y%m%d%H", hour.utctimetuple())
    data = []
    try:
        fnames = os.listdir(portal.config.file('sensor_health_path',
                                               hour_directory))
    except OSError, e:
        # Ignore missing directories
        if e.errno == errno.ENOENT:
            fnames = []
        else:
            raise
    for fname in fnames:
        if not fname.startswith("%s-" % sensor):
            continue
        data.extend(parsefile(
            os.path.join(portal.config.file('sensor_health_path',
                                            hour_directory),
                         fname)))
    return data

def gen_data(sensor, sdate, edate):
    curr_date = copy.copy(sdate)
    data = []
    while curr_date <= edate:
        data.extend(gen_data_hour(sensor, curr_date))
        curr_date += timedelta(seconds=3600)
    return data
        

@op_file
@typemap(sensors=str,
         edate=datetime_obj, dur=str,
         width=int, height=int)
@expires(nocache) # TODO: make this a real duration
def vis_sensor_health(out_file_name, sensors, edate, dur, width, height):
    sensors = get_sensors(sensors)
    sdate = sub_duration(edate, dur)
    series = []
    for sensor in sensors:
        d = gen_data(sensor, sdate, edate)
    #   matplotlib will barf if we ask it to boxplot an empty
    #   array, so....
        if len(d) == 0:
            d = [0]
        series.append(d)

    render_boxplot(out_file_name, series, sensors, width, height, vert=0)


__export__ = {
    'other/sensor-health': vis_sensor_health,
}
