import sys
import datetime
from rave.plugins.times import sub_duration
import watchlists
from portal.util import *

import silk
silk.DEBUG_VERBOSE=True

all_sensors = get_sensors('all')


def precache(dur):
    one_day = timedelta(days=1)
    edate = datetime.datetime.utcnow() + one_day
#   Round edate up to nearest day
    edate = datetime.datetime(edate.year, edate.month, edate.day)
    sdate = sub_duration(edate, dur)
    while edate >= sdate:
        precache_susp_hosts(sdate, edate)
        precache_susp_ports(sdate, edate)
        precache_darknet(sdate, edate)
        edate = edate - one_day
        

    
    
def precache_susp_hosts(sdate, edate):
    data = watchlists.gen_susp_hosts_list(sdate, edate, all_sensors, 0)
    for ip in data['key']:
        watchlists.gen_susp_hosts_histogram(sdate, edate, all_sensors, ip)    
        watchlists.gen_susp_hosts_timeseries(sdate, edate, all_sensors, ip)

def precache_susp_ports(sdate, edate):
    data = watchlists.gen_susp_ports_list(sdate, edate, all_sensors, 0)
    for ip in data['key']:
        watchlists.gen_susp_ports_histogram(sdate, edate, all_sensors, ip)    
        watchlists.gen_susp_ports_timeseries(sdate, edate, all_sensors, ip)

    
def precache_darknet(sdate, edate):
    data = watchlists.gen_darknet_list(sdate, edate, all_sensors, 0)
    for ip in data['key']:
        watchlists.gen_darknet_histogram(sdate, edate, all_sensors, ip)    
        watchlists.gen_darknet_timeseries(sdate, edate, all_sensors, ip)
 

if __name__ == '__main__':
    precache(sys.argv[1])
    
