import sys
import time

from rave.cache.core import Cache, NOW, NEVER
from rave.util.options import OptionList, Option
from rave.plugins.times import parse_any_datetime

opts = [
    ['r' , 'repository', 'path'  , str, "Path to repository"],
    [None, 'print'     , 'string', str, "Print meta-information"],
    # Predicates
    ['t' , 'mime-type' , 'string', str, "MIME type of selected files"],
    ['n' , 'op-name'   , 'string', str, "Name of op used to create entry"],
    ['f' , 'op-file'   , 'string', str, "Filename of op used to create entry"],
    ['v' , 'op-version', 'string', str, "Version of op used to create entry"],
    ['e' , 'expires'   , 'string', str, "Expires at this time"],
    ['b' , 'before'    , 'string', str, "Expires before this time (TODO)"],
    ['a' , 'after'     , 'string', str, "Expires after this time (TODO)"],
]

def datecmp(expires, value):
    # Return:
    # -1 if expires < value,
    #  0 if expires == value,
    #  1 if expires > value
    # value should always be what is passed in from the command-line
    if value == 'NEVER':
        if expires == -1:
            return 0
        return -1
    elif value == 'NOW':
        if expires == 0:
            return 0
        return 1
    else:
        value = parse_any_datetime(value)
        expires = parse_any_datetime(expires)
        if expires < value:
            return -1
        if expires == value:
            return 0
        return 1
    

predicates = {
    'mime-type' : (lambda m,v: m.mime_type == v),
    'op-name'   : (lambda m,v: m.callinfo.op_name == v),
    'op-file'   : (lambda m,v: m.callinfo.op_file == v),
    'op-version': (lambda m,v: m.callinfo.op_version == v),
    'expires'              : (lambda m,v: datecmp(m.expires, v) == 0),
    'expires-before'       : (lambda m,v: datecmp(m.expires, v) <  0),
    'expires-after'        : (lambda m,v: datecmp(m.expires, v) >  0),
    'expires-on-or-before' : (lambda m,v: datecmp(m.expires, v) <= 0),
    'expires-on-or-after'  : (lambda m,v: datecmp(m.expires, v) >= 0),
}

def timefmt(t):
    if t == NOW:
        return "Auto-expire"
    elif t == NEVER:
        return "Never"
    else:
        ftime = time.strftime(
              "%Y-%m-%dT%H:%M:%S", time.localtime(t)) 
        msecs = (t - long(t)) * 1000
        return "%s,%03d" % (ftime, msecs)

def print_meta(meta, value):
    if value == 'info':
        print "%s (%s:%s)" % (meta.callinfo.op_name,
                              meta.callinfo.op_file,
                              meta.callinfo.op_version)
        print "Created: %s; Expires: %s" % (timefmt(meta.created_timestamp),
                                            timefmt(meta.expires))
        print "Arguments:"
        def stringify(x):
            try:
                return str(x)
            except:
                return "(Can't stringify)"
        for k, v in meta.callinfo.args.items():
            print "\t%s: %s" % (stringify(k), stringify(v))
    elif value == 'stub':
        print meta.file_name()[:-5]
    elif value == 'meta':
        print meta.file_name()
    elif value == 'data':
        print meta.data_file()
    elif value == 'both':
        print meta.file_name()
        print meta.data_file()
    else:
        raise RuntimeError("Unrecognized value for print: %s" % value)

def main(args):
    cache = Cache(args.pop('repository'))
    print_style = args.pop('print', 'stub')
    for meta in cache.repository.all_metas():
        satisfied = True
        for k,v in args.items():
            pred = predicates[k]
            if not pred(meta, v):
                satisfied = False
        if satisfied:
            print_meta(meta, print_style)
        

if __name__ == '__main__':
    # Parse arguments
    olist = OptionList.from_options([Option(*x) for x in opts])
    args = olist.parse(sys.argv[1:])
    main(args)
