#!/usr/bin/env python
# rave-get - retrieve a visualization from a RAVE server

import sys
from rave.client import fetch_ticket, RaveCommunicationError
from optparse import OptionParser

buffer_size=65536

parser = OptionParser(usage="usage: %prog [options] query [X=Y ...]")
parser.add_option("--service", dest="service_url",
                  default='http://localhost:8888/',
                  help="Request from RAVE running at URL", metavar="URL")
parser.add_option("--output", dest="output_file",
                  help="Write result to FILE", metavar="FILE")
parser.add_option("-v", "--verbose", dest="verbose", action="store_true",
                  help="Verbose output", default=False)
parser.add_option("--wait", dest="wait_secs", 
                  help=("Wait until the request is complete, or for SECS, " +
                        "whichever comes first."),
                  metavar='SECS', default=None)

(options, args) = parser.parse_args()

if len(args) < 1:
    parser.print_help()
    sys.exit(-1)

query_name = args[0]
args = args[1:]

def arg_to_param(arg):
    arg_parts = arg.split('=', 1)
    if len(arg_parts) == 1:
        return (arg_parts[0], '')
    else:
        return tuple(arg_parts)
params = dict(map(arg_to_param, args))

service_url = options.service_url
output_file = options.output_file or None
wait_secs = options.wait_secs or None
verbose_mode = options.verbose or False

try:
    t = fetch_ticket(service_url, query_name, params, wait_secs)
except RaveCommunicationError, e:
    if e.code == 404:
        print >>sys.stderr, "Error: Request URI not found"
    elif e.code == 500:
        print >>sys.stderr, "Error: %s" % e.msg
    else:
        print >>sys.stderr, "Error: %s %s" % (e.code, e.msg)
    sys.exit(-1)

if verbose_mode:
    print >>sys.stderr, "Ticket URI: %s\n  Content-Type: %s" % \
          (t.get_uri(), t.get_content_type())

if output_file:
    out = file(output_file, 'w')
    s = t.get_stream()
    data = s.read(buffer_size)
    while data <> '':
        out.write(data)
        data = s.read(buffer_size)
    s.close()
    out.close()
