import os.path

import handlers
import rave.plugins.decorators as rcdeco
from rave.plugins.render_mpl import *

def show(opfile, *args, **kwargs):
    mime_type = opfile.mime_type
    try:
        handler = handlers.handlers[mime_type]
    except KeyError:
        print ("Unknown mime type '%s':"
               " using default handler" % mime_type)
        handler = handlers.handlers['default']
    fname = opfile(*args, **kwargs)
    handler(fname)
    #handler(os.path.join(
    #    rcdeco.fname_cache.repository.root_dir(), fname))


__all__ = ['show']
