"""
RAVE interface to relational databases
"""

__version__ = "$Rev: 7878 $"



from rave.plugins.decorators import *
from rave.plugins.dataset import Dataset
import rave.log as rlog
get_log = rlog.log_factory("rave.plugins.db")

from db_utils import parse_db_url

drivers = {}

class RaveDatabaseDriverError(Exception):
    "Database driver unavailable"
    def __init__(self, drivername):
        Exception.__init__(self)
        self.drivername = drivername
    def __str__(self):
        return "Database driver unavailable: %s" % (self.drivername)


try:
    import rave.plugins.db_mysql as mysql
    drivers['mysql'] = mysql
except ImportError:
    pass

try:
    import rave.plugins.db_oracle as oracle
    drivers['oracle'] = oracle
except ImportError:
    pass
    
try:
    import rave.plugins.db_postgres as postgresql
    drivers['postgresql'] = postgresql
except ImportError:
    pass

def get_connection(connect_url):
    drivername = parse_db_url(connect_url)['driver']
    if drivername not in drivers:
        raise RaveDatabaseDriverError(drivername)
    return drivers[drivername].get_connection(connect_url)

def release_connection(conn):
    if conn:
        conn.close()

@op
def query(connect_url, sql, keywords):
    conn = None
    try:
        conn = get_connection(connect_url)
        cur = conn.cursor()
        cur.execute(sql, keywords)
        column_names = []
        rows = cur.fetchall()
        
        if len(rows) == 0:
            rows = None

        for column in cur.description:
            column_names.append(column[0])

        data = Dataset(_columns=column_names, _row_data=rows)
        return data
        
    finally:
        if conn: conn.close()

