"""
MySQL database functions for RAVE analyses.
"""

__version__ = "$Rev: 7370 $"


from rave.plugins.dataset import Dataset
from db_utils import parse_db_url

try:
    import MySQLdb as driver
except ImportError, err:
    raise ImportError(err)

# Provides ability to add in pooling later
def get_connection(connect_url):
    cd = parse_db_url(connect_url)
    kwargs = {}
    if 'host' in cd and cd['host'] <> None: kwargs['host'] = cd['host']
    if 'port' in cd and cd['port'] <> None: kwargs['port'] = int(cd['port'])
    if 'user' in cd and cd['user'] <> None: kwargs['user'] = cd['user']
    if 'pass' in cd and cd['pass'] <> None: kwargs['pass'] = cd['pass']
    if 'db' in cd and cd['db'] <> None: kwargs['db'] = cd['db']
    return driver.connect( **kwargs )

