"""
Oracle database functions for RAVE analyses.
"""

__version__ = "$Rev: 7370 $"


from rave.plugins.dataset import Dataset
from db_utils import parse_db_url

try:
    import cx_Oracle as driver
except ImportError, err:
    raise ImportError(err)

default_port = 1521

# Provides ability to add in pooling later
def get_connection(connect_url):
    cd = parse_db_url(connect_url)
    if cd['port'] == None:
        cd['port'] = 1521
    dsn = driver.makedsn(cd['host'], cd['port'], cd['db'])
    kwargs = {}
    if 'user' in cd and cd['user'] <> None: kwargs['user'] = cd['user']
    if 'pass' in cd and cd['pass'] <> None: kwargs['passwd'] = cd['pass']
    return driver.connect(dsn=dsn, **kwargs)
