"""
Postgres database functions for RAVE analyses.
"""

__version__ = "$Rev: 9051 $"


from rave.plugins.dataset import Dataset
from db_utils import parse_db_url

# Load whichever PostgreSQL drivers are available, giving preference
# to psycopg2, then psycopg, then finally pgdb (PyGreSQL)
try:
    import psycopg2 as driver
except ImportError:
    try:
        import psycopg as driver
    except ImportError:
        try:
            import pgdb as driver
        except ImportError:
            raise ImportError("No drivers available")
 
# Provides ability to add in pooling later
def get_connection(connect_url):
    cd = parse_db_url(connect_url)
    kwargs = {}
    if 'host' in cd and cd['host'] <> None: kwargs['host'] = cd['host']
    if 'port' in cd and cd['port'] <> None: kwargs['port'] = int(cd['port'])
    if 'user' in cd and cd['user'] <> None: kwargs['user'] = cd['user']
    if 'pass' in cd and cd['pass'] <> None: kwargs['password'] = cd['pass']
    if 'db' in cd and cd['db'] <> None: kwargs['database'] = cd['db']
    conn = driver.connect( **kwargs )
    cur = conn.cursor()
    cur.execute("set timezone = 'UTC'")
    cur.close()
    return conn
