"""
Database utility functions
"""

__version__ = "$Rev: 8950 $"

import re

# Parse an RFC-1738-looking database URL.
# Example URL:  postgresql://hello:hackme@server.domain.com:1234/foo
def parse_db_url(connect_string):
    m = re.match("(.+)://(?:([^:]+)(?::(.+))?@)?(?:([^:/]+)(?::(\d+))?)?(?:/(.+))?",
        connect_string)
    d = dict(zip(['driver', 'user', 'pass', 'host', 'port', 'db'],
        m.groups()))

    return d
