"""
HTML renderers
"""

__version__ = "$Rev$"

import sys
from rave.plugins.decorators import *
from rave.plugins.shell import *
from rave.plugins.dataset import Dataset

# render_html_table([{'title': 'Foo/min', 'data': d['foo']},
#                    {'title': 'Tab', 'align': 'left', 'data': d['bar']}])

def render_html_table(out_file_name, config, stylesheet=None):
    f = open(out_file_name, 'w')
    # Make sure there's some data:
    if len(config[0]['data']) == 0 :
        f.write('<p style="text-align: center">no data</p>')
        f.close()
        return
    f.write('<table><thead><tr>')
    for k in config:
        f.write('<th>%s</th>' % k['title'])
    f.write('</tr></thead><tbody>')
    for i in xrange(len(config[0]['data'])):
        f.write('<tr>')
        for j in xrange(len(config)):
            f.write('<td')
            if 'align' in config[j]:
                f.write(' align="%s"' % config[j]['align'])
            else:
                f.write(' align="right"')
            f.write('>%s</td>' % config[j]['data'][i])
        f.write('</tr>')
    f.write('</tbody></table>')
    f.close()

def render_html_chart_overlay(out_file_name, width, height, labels, urls):
    f = open(out_file_name, 'w')
    f.write('<div class="image-overlay" style="width:%dpx;height:%dpx;position:absolute;top:0;left:0">' % (width, height))
    margin_top = 32
    margin_left = 96
    margin_bottom = 48
    margin_right = 64
    row_spacing = 8
    label_left_space = 16
    label_bottom_space = 0
    n = len(labels)
    box_height = height - margin_top - margin_bottom - row_spacing * (n-1)
    box_height = box_height / n
    rem_height = (height - margin_top - margin_bottom - row_spacing * (n-1) -
                  box_height * n)
    for i in xrange(n):
        neg_i = n - i - 1
        if urls[i] is not None:
            f.write('<a href="%s" title="%s" class="image-overlay-box" style='
                    '"position: absolute;top:%dpx;left:%dpx;width:%dpx;height:%dpx">' %
                    (urls[i], labels[i],
                     margin_top + i * (box_height + row_spacing),
                     margin_left, width - margin_left - margin_right - 1,
                     box_height - 1))
            f.write('</a>')
    f.write('</div>')
    f.close()
