from errno import ENOENT, ENOTDIR
from threading import *
import sys, os, time, silk

try:
    MAXFD = os.sysconf("SC_OPEN_MAX")
except:
    MAXFD = 256

def run_process(prog, args, stdin=None, stdout=None):
    cmdargs = [str(a) for a in args]
    if isinstance(stdin, str):
        stdin = open(str(stdin), 'rb')
    if isinstance(stdout, str):
        stdout = open(str(stdout), 'wb')
    if silk.DEBUG_DRY_RUN or silk.DEBUG_VERBOSE:
        message = prog + ' ' + ' '.join(cmdargs)
        if stdin: message += ' < ' + stdin.name
        if stdout: message += ' > ' + stdout.name
        silk.debug(message)
    if silk.DEBUG_DRY_RUN:
        return
    cmdargs = [prog] + cmdargs
    if stdin == None: stdin = open('/dev/null', 'rb')
    if stdout == None: stdout = open('/dev/null', 'wb')
    stderr_r_fd, stderr_w_fd = os.pipe()
    pid = os.fork()
    if pid == 0:
        # We are the child.
        #
        # Never raise exceptions or call sys.exit() in this code
        # block! Always either exec or call os._exit() to end the
        # child.
        try:
            try:
                os.dup2(stdin.fileno(), sys.stdin.fileno())
            except:
                pass
            try:
                os.dup2(stdout.fileno(), sys.stdout.fileno())
            except:
                pass
            try:
                os.dup2(stderr_w_fd, sys.stderr.fileno())
            except:
                pass
            for i in xrange(3, MAXFD):
                try:
                    os.close(i)
                except:
                    pass
            dir, basename = os.path.split(prog)
            if dir:
                os.execv(prog, cmdargs)
            else:
                default_path = (
                    '/usr/bin:/bin:/usr/sbin:/sbin:'
                    '/usr/local/bin:/usr/local/sbin'
                )
                path = os.environ.get('PATH', default_path).split(':')
                for dir in path:
                    prog = os.path.join(dir, basename)
                    try:
                        os.execv(prog, [prog] + cmdargs[1:])
                    except os.error, e:
                        if e.errno not in (ENOENT, ENOTDIR):
                            raise
                print >>sys.stderr, (
                    "No suitable executable for %s found" % basename)
                os._exit(1)
        finally:
            # This code path should be unreachable, unless there's a
            # logic error somewhere above. 
            print >>sys.stderr, "Unterminated child process"
            os._exit(1)
    else:
        # We are the parent
        os.close(stderr_w_fd)
        stdin.close()
        stdout.close()
        stderr_text = ''
        buf = None
        while buf <> '':
            buf = os.read(stderr_r_fd, 4096)
            stderr_text += buf
        (done_pid, exit_status) = os.waitpid(pid, 0)
        os.close(stderr_r_fd)
        if exit_status <> 0:
            if stderr_text:
                raise silk.SilkError(stderr_text)
            else:
                if os.WIFEXITED(exit_status):
                    raise silk.SilkError("%s exited with status %d" %
                                         (prog, os.WEXITSTATUS(exit_status)))
                elif os.WIFSTOPPED(exit_status):
                    raise silk.SilkError("%s stopped with signal %d" %
                                         (prog, os.WSTOPSIG(exit_status)))
                elif os.WIFSIGNALED(exit_status):
                    raise silk.SilkError("%s terminated with signal %d" %
                                         (prog, os.WTERMSIG(exit_status)))
                else: # ???
                    raise silk.SilkError("%s finished with non-zero "
                                         "exit status %d" % (prog, exit_status))
                

import imp

# Reason for imp.lock_held check:
# If the import lock is held, we have to be very careful about starting
# new threads, since they will run code which may want to import things.
# So, don't do that.

def run_in_thread(f, *args, **kwargs):
    if silk.DEBUG_SINGLE_THREAD or imp.lock_held():
        f(*args, **kwargs)
        return
    Thread(target=f, args=args, kwargs=kwargs).start()
