# RCSIDENT("$SiLK: build.mk 7d696fd1589e 2011-01-05 17:15:23Z mthomas $")

# Local rules

clean-local: clean-remove-man clean-remove-tests-output


# Rules to build (and clean) the manual pages (troff) from the Perl
# POD (Plain Old Documentation) source files
#
POD2MAN_ARGS = --center="SiLK Tool Suite" --release="$(PACKAGE_STRING)"

.pod.man:
	$(POD2MAN) $(POD2MAN_ARGS) $< > $@
.pod.1:
	$(POD2MAN) --section=1 $(POD2MAN_ARGS) $< > $@
.pod.2:
	$(POD2MAN) --section=2 $(POD2MAN_ARGS) $< > $@
.pod.3:
	$(POD2MAN) --section=3 $(POD2MAN_ARGS) $< > $@
.pod.5:
	$(POD2MAN) --section=5 $(POD2MAN_ARGS) $< > $@
.pod.7:
	$(POD2MAN) --section=7 $(POD2MAN_ARGS) $< > $@
.pod.8:
	$(POD2MAN) --section=8 $(POD2MAN_ARGS) $< > $@

clean-remove-man:
	-$(RM) -f $(man1_MANS) $(man2_MANS) $(man3_MANS) $(man5_MANS) $(man7_MANS) $(man8_MANS)

clean-remove-tests-output:
	-$(RM) -f $(SILK_TESTS_OUTPUT)


# DAEMON CONFIGURATION
#
#  The following support daemon configuration files

#  Convert @foo@ int the .conf and .init.d files to path names
edit_conf_init_d = sed \
	-e 's|@SILK_DATA_ROOTDIR[@]|$(SILK_DATA_ROOTDIR)|g' \
	-e 's|@localstatedir[@]|$(localstatedir)|g' \
	-e 's|@sbindir[@]|$(sbindir)|g' \
	-e 's|@sysconfdir[@]|$(sysconfdir)|g'


# Rules to create the .conf files used by daemons and to install the
# files into $(prefix)/share/silk/etc/
#
conf_file_dir = $(pkgdatadir)/etc

make-conf-files: Makefile
	@list='$(conf_files)'; for p in $$list; do \
	  if test -f "$$p.in"; then d=; else d="$(srcdir)/"; fi; \
	  echo " Creating $$p from $$d$$p.in" ; \
	  rm -f $$p $$p.tmp ; \
	  $(edit_conf_init_d) "$$d$$p.in" > $$p.tmp ; \
	  mv $$p.tmp $$p ; \
	done

install-conf-files: $(conf_files)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(conf_file_dir)
	@list='$(conf_files)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f="`echo $$p | sed -e 's,^.*/,,;$(transform)'`"; \
	  echo " $(INSTALL_DATA) $$d$$p $(DESTDIR)$(conf_file_dir)/$$f"; \
	  $(INSTALL_DATA) $$d$$p $(DESTDIR)$(conf_file_dir)/$$f; \
	done

uninstall-conf-files:
	@$(NORMAL_UNINSTALL)
	@list='$(conf_files)'; for p in $$list; do \
	  f="`echo $$p | sed -e 's,^.*/,,;$(transform)'`"; \
	  echo " rm -f $(DESTDIR)$(conf_file_dir)/$$f"; \
	  rm -f $(DESTDIR)$(conf_file_dir)/$$f; \
	done


# Rules to create the .init.d files used by daemons and to install the
# files into $(prefix)/share/silk/etc/init.d/
#
init_d_scripts_dir = $(pkgdatadir)/etc/init.d

make-init-d-files: Makefile
	@list='$(init_d_scripts)'; for p in $$list; do \
	  if test -f "$$p.in"; then d=; else d="$(srcdir)/"; fi; \
	  echo " Creating $$p from $$d$$p.in" ; \
	  rm -f $$p $$p.tmp ; \
	  $(edit_conf_init_d) "$$d$$p.in" > $$p.tmp ; \
	  chmod +x $$p.tmp ; \
	  mv $$p.tmp $$p ; \
	done

install-init-d-scripts: $(init_d_scripts)
	@$(NORMAL_INSTALL)
	$(mkinstalldirs) $(DESTDIR)$(init_d_scripts_dir)
	@list='$(init_d_scripts)'; for p in $$list; do \
	  if test -f "$$p"; then d=; else d="$(srcdir)/"; fi; \
	  f="`echo $$p | sed -e 's,^.*/,,;s,\.init\.d$$,,;$(transform)'`"; \
	  echo " $(INSTALL_SCRIPT) $$d$$p $(DESTDIR)$(init_d_scripts_dir)/$$f"; \
	  $(INSTALL_SCRIPT) $$d$$p $(DESTDIR)$(init_d_scripts_dir)/$$f; \
	done

uninstall-init-d-scripts:
	@$(NORMAL_UNINSTALL)
	@list='$(init_d_scripts)'; for p in $$list; do \
	  f="`echo $$p | sed -e 's,^.*/,,;s,\.init\.d$$,,;$(transform)'`"; \
	  echo " rm -f $(DESTDIR)$(init_d_scripts_dir)/$$f"; \
	  rm -f $(DESTDIR)$(init_d_scripts_dir)/$$f; \
	done

.PHONY: clean-remove-man clean-remove-tests-output \
	make-conf-files install-conf-files uninstall-conf-files \
	make-init-d-files install-init-d-scripts uninstall-init-d-scripts
