#! /usr/bin/perl -w
#
#
# RCSIDENT("$SiLK: flowcap-ipfix.pl 72e0a2f73883 2010-09-09 21:30:31Z mthomas $")

use strict;
use SiLKTests;

# find the apps we need.  this will exit 77 if they're not available
my $rwcat = check_silk_app('rwcat');
my $rwsort = check_silk_app('rwsort');
my $rwsilk2ipfx = check_silk_app('rwsilk2ipfix');

# find the data files we use as sources, or exit 77
my %file;
$file{data} = get_data_or_exit77('data');

# verify that we have FIXBUF support
exit 77 unless $SiLKTests::SK_ENABLE_IPFIX;

# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# create our tempdir.  clean up unless the appropriate environment
# variable is set.
my $tmpdir = File::Temp::tempdir(CLEANUP => !$ENV{SK_TESTS_SAVEOUTPUT});
exit 77 unless -d $tmpdir;

# Generate the test data
my $ipfixdata = "$tmpdir/data.ipfix";
unlink $ipfixdata;
system "$rwsilk2ipfx --ipfix-output=$ipfixdata $file{data}"
    and die "ERROR: Failed running rwsilk2ipfx\n";

# the command that wraps flowcap
my $cmd = join " ", ("$SiLKTests::PYTHON $srcdir/tests/flowcap-daemon.py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     "--tcp $ipfixdata:9999",
                     "--limit=501876",
                     "--basedir=$tmpdir",
                     "--",
                     "--sensor-conf=$srcdir/tests/sensors-ipfix.conf",
                     "--max-file-size=100k",
    );

# run it and check the MD5 hash of its output
check_md5_output('a78a286719574389a972724d761c931e', $cmd);

# path to the directory holding the output files
my $data_dir = "$tmpdir/destination";
die "ERROR: Missing data directory '$data_dir'\n"
    unless -d $data_dir;

# check for zero length files in the directory
opendir D, "$data_dir"
    or die "ERROR: Unable to open directory $data_dir: $!\n";
for my $f (readdir D) {
    next if (-d "$data_dir/$f") || (0 < -s _);
    warn "WARNING: Zero length files in $data_dir\n";
    last;
}
closedir D;

# create a command to sort all files in the directory and output them
# in a standard form.
$cmd = ("find $data_dir -type f -print "
        ." | $rwcat --xargs "
        ." | $rwsort --fields=stime,sip "
        ." | $rwcat --byte-order=little --compression-method=none"
        ." --ipv4-output");

# because the IPv4 flowcap file format encodes bytes as a
# bytes-per-packet and the IPv6 does not, the results will be slightly
# different depending on whether SiLK was compiled with IPv6 support
my $md5 = (($SiLKTests::SK_ENABLE_IPV6)
           ? 'f7dd43c84ada69e12a7e55f6d7d4b81b'
           : 'a1301f02ea01cfd3c8cee813b3e40ada');

exit check_md5_output($md5, $cmd);
