#! /usr/bin/perl -w
#
#
# RCSIDENT("$SiLK: flowcap-netflowv5.pl 72e0a2f73883 2010-09-09 21:30:31Z mthomas $")

use strict;
use SiLKTests;

# find the apps we need.  this will exit 77 if they're not available
my $rwcat = check_silk_app('rwcat');
my $rwsort = check_silk_app('rwsort');

# find the data files we use as sources, or exit 77
my %file;
$file{data} = get_data_or_exit77('data');

# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# create our tempdir.  clean up unless the appropriate environment
# variable is set.
my $tmpdir = File::Temp::tempdir(CLEANUP => !$ENV{SK_TESTS_SAVEOUTPUT});
exit 77 unless -d $tmpdir;

# the command that wraps flowcap
my $cmd = join " ", ("$SiLKTests::PYTHON $srcdir/tests/flowcap-daemon.py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     "--pdu 40000:9999",
                     "--limit=40000",
                     "--basedir=$tmpdir",
                     "--daemon-timeout=120",
                     "--",
                     "--sensor-conf=$srcdir/tests/sensors-netflowv5.conf",
                     "--max-file-size=100k",
                     "--clock-time=2"
    );

# run it and check the MD5 hash of its output
check_md5_output('f6e9b35dc226f9975c8c14d9ab332bd7', $cmd);

# path to the directory holding the output files
my $data_dir = "$tmpdir/destination";
die "ERROR: Missing data directory '$data_dir'\n"
    unless -d $data_dir;

# check for zero length files in the directory
opendir D, "$data_dir"
    or die "ERROR: Unable to open directory $data_dir: $!\n";
for my $f (readdir D) {
    next if (-d "$data_dir/$f") || (0 < -s _);
    warn "WARNING: Zero length files in $data_dir\n";
    last;
}
closedir D;

# create a command to sort all files in the directory and output them
# in a standard form.
$cmd = ("find $data_dir -type f -print "
        ." | $rwcat --xargs "
        ." | $rwsort --fields=stime,sip "
        ." | $rwcat --byte-order=little --compression-method=none"
        ." --ipv4-output");

exit check_md5_output('4ac59f73c7d70e777982e9907952c9a3', $cmd);
