#! /usr/bin/perl -w
# MD5: 9023f1c798bdb82b606da5a9d4323e32
# TEST: ./rwfilter --proto=17 --max-pass=100 --max-fail=200 --pass=./sk-teststmp-PCBydKrj --fail=./sk-teststmp-eH6FUiRi ../../tests/data.rwf && ../rwcut/rwcut --fields=1-10 --ipv6-policy=ignore ./sk-teststmp-PCBydKrj ./sk-teststmp-eH6FUiRi

use strict;
use SiLKTests;

my $rwfilter = $ENV{RWFILTER} || './rwfilter';
my $rwcut = check_silk_app('rwcut');
my %file;
$file{data} = get_data_or_exit77('data');
my %temp;
$temp{pass} = make_tempname('pass');
$temp{fail} = make_tempname('fail');
my $cmd = "$rwfilter --proto=17 --max-pass=100 --max-fail=200 --pass=$temp{pass} --fail=$temp{fail} $file{data} && $rwcut --fields=1-10 --ipv6-policy=ignore $temp{pass} $temp{fail}";
my $md5 = "9023f1c798bdb82b606da5a9d4323e32";

check_md5_output($md5, $cmd);
