#! /usr/bin/perl -w
#
#
# RCSIDENT("$SiLK: rwflowpack-pack-bad-fcfile.pl 0434310a1001 2010-12-16 18:09:16Z mthomas $")

use strict;
use SiLKTests;
use File::Find;

my $rwflowpack = $ENV{RWFLOWPACK} || './rwflowpack';

# find the apps we need.  this will exit 77 if they're not available

# find the data files we use as sources, or exit 77
my %file;
$file{empty} = get_data_or_exit77('empty');

# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# set the environment variables required for rwflowpack to find its
# packing logic plug-in
add_plugin_dirs('/site/twoway');

# Skip this test if we cannot load the packing logic
check_exit_status("$rwflowpack --sensor-conf=$srcdir/tests/sensor77.conf"
                  ." --verify-sensor-conf")
    or exit 77;

# create our tempdir.  clean up unless the appropriate environment
# variable is set.
my $tmpdir = File::Temp::tempdir(CLEANUP => !$ENV{SK_TESTS_SAVEOUTPUT});
exit 77 unless -d $tmpdir;

# Generate the sensor.conf file
my $sensor_conf = "$tmpdir/sensor-templ.conf";
make_packer_sensor_conf($sensor_conf, 'silk', 'polldir');

# the invalid files
my %inval;

# file handle
my $fh;

# create a completely invalid file containing the file's own name
($fh, $inval{junk}) = File::Temp::tempfile("$tmpdir/junk.XXXXXX");
print $fh $inval{junk};
close $fh
    or die "ERROR: Cannot close $inval{junk}: $!\n";

# Create a file containing only the flowcap file header.
($fh, $inval{empty}) = File::Temp::tempfile("$tmpdir/empty.XXXXXX");
binmode $fh;
print $fh
    "\xde\xad\xbe\xef\x01\x1c\x10\x00\x00\x00\x00\x00\x00\x26\x00\x05",
    "\x00\x00\x00\x04\x00\x00\x00\x0b\x50\x30\x00\x00\x00\x00\x00\x00",
    "\x00\x00\x0b\x00\x00\x00";
close $fh
    or die "Cannot close $inval{empty}: $!\n";

# Create a copy of the empty data file (missing the probe header)
$inval{noprobe} = File::Temp::mktemp("$tmpdir/noprobe.XXXXXX");
system 'cp', $file{empty}, $inval{noprobe};

# construct the expected archive_directory
my @t = gmtime();
my $archive_dir = sprintf("%s/archive/%4d/%02d/%02d/%02d/",
                          $tmpdir, (1900 + $t[5]), (1 + $t[4]), $t[3], $t[2]);

# the command that wraps rwflowpack
my $cmd = join " ", ("$SiLKTests::PYTHON $srcdir/tests/rwflowpack-daemon.py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     "--sensor-conf=$sensor_conf",
                     (map {"--move $inval{$_}:incoming"} keys %inval),
                     "--basedir=$tmpdir",
                     "--daemon-timeout=15",
                     "--flush-timeout=4",
                     "--",
                     "--polling-interval=5",
                     "--incoming-directory=$tmpdir/incoming",
                     "--input-mode=fcfiles",
    );

# run it and check the MD5 hash of its output
check_md5_output('8d06e798951bc231967e43b2f18f3499', $cmd);

# the following directories should be empty
my @empty_dirs = qw(incoming incremental root sender);
for my $d (map {"$tmpdir/$_"} @empty_dirs) {
    next unless -d $d;
    unless (opendir D, $d) {
        warn "ERROR: Cannot open directory '$d': $!\n";
        next;
    }
    while (my $f = readdir(D)) {
        next if $f =~ /^\.\.?$/;
        die "ERROR: Found unexpected file '$d/$f'\n";
    }
}

# verify files are in the archive directory
unless (-d $archive_dir) {
    # maybe the hour changed during the run?
    @t = gmtime();
    $archive_dir = sprintf("%s/archive/%4d/%02d/%02d/%02d/",
                           $tmpdir, (1900 + $t[5]), (1 + $t[4]), $t[3], $t[2]);
    die "ERROR: Missing archive directory '$archive_dir'\n"
        unless -d $archive_dir;
}
for my $f ($inval{empty}) {
    $f =~ s,.*/,$archive_dir,;
    die "ERROR: Missing archive file '$f'\n"
        unless -f $f;
}

# verify files in the error directory
my $error_dir = "$tmpdir/error/";
die "ERROR: Missing  directory '$error_dir'\n"
    unless -d $error_dir;
for my $f (grep {!/empty/} values %inval) {
    $f =~ s,.*/,$error_dir,;
    die "ERROR: Missing error file '$f'\n"
        unless -f $f;
}

exit 0;
