#! /usr/bin/perl -w
#
#
# RCSIDENT("$SiLK: rwflowpack-pack-multiple2.pl 72e0a2f73883 2010-09-09 21:30:31Z mthomas $")

use strict;
use SiLKTests;
use File::Find;

my $rwflowpack = $ENV{RWFLOWPACK} || './rwflowpack';

# find the apps we need.  this will exit 77 if they're not available
my $rwcat = check_silk_app('rwcat');
my $rwuniq = check_silk_app('rwuniq');

# find the data files we use as sources, or exit 77
my %file;
$file{data} = get_data_or_exit77('data');
$file{pdu} = get_data_or_exit77('pdu_small');

# prefix any existing PYTHONPATH with the proper directories
check_python_bin();

# set the environment variables required for rwflowpack to find its
# packing logic plug-in
add_plugin_dirs('/site/twoway');

# Skip this test if we cannot load the packing logic
check_exit_status("$rwflowpack --sensor-conf=$srcdir/tests/sensor77.conf"
                  ." --verify-sensor-conf")
    or exit 77;

# create our tempdir.  clean up unless the appropriate environment
# variable is set.
my $tmpdir = File::Temp::tempdir(CLEANUP => !$ENV{SK_TESTS_SAVEOUTPUT});
exit 77 unless -d $tmpdir;

# Generate the sensor.conf file
my $sensor_conf = "$srcdir/tests/sensors-multiple2.conf";

# the command that wraps rwflowpack
my $cmd = join " ", ("$SiLKTests::PYTHON $srcdir/tests/rwflowpack-daemon.py",
                     ($ENV{SK_TESTS_VERBOSE} ? "--verbose" : ()),
                     #"--log-level=debug",
                     "--sensor-conf=$sensor_conf",
                     "--copy $file{data}:incoming",
                     "--copy $file{data}:incoming2",
                     "--copy $file{pdu}:incoming3",
                     "--copy $file{pdu}:incoming4",
                     "--limit=1103752",
                     "--basedir=$tmpdir",
                     "--daemon-timeout=90",
                     "--",
                     "--polling-interval=5",
    );

# run it and check the MD5 hash of its output
check_md5_output('e4d9a9fe18a95da02c3cf1123e9b8139', $cmd);


# the following directories should be empty
my @empty_dirs = qw(error incoming incremental sender);
for my $d (map {"$tmpdir/$_"} @empty_dirs) {
    next unless -d $d;
    unless (opendir D, $d) {
        warn "ERROR: Cannot open directory '$d': $!\n";
        next;
    }
    while (my $f = readdir(D)) {
        next if $f =~ /^\.\.?$/;
        die "ERROR: Found unexpected file '$d/$f'\n";
    }
}

# path to the data directory
my $data_dir = "$tmpdir/root";
die "ERROR: Missing data directory '$data_dir'\n"
    unless -d $data_dir;

# check the output
$cmd = ("find $data_dir -type f -print"
        ." | $rwcat --xargs"
        ." | $rwuniq --ipv6=ignore --fields=sip,sensor,type,stime"
        ." --values=records,packets,stime,etime --sort");
check_md5_output('4a1590da169fc2c3d3ea9c4b2e4aae58', $cmd);

# successful!
exit 0;
