#! /usr/bin/perl -w
# MD5: 41554ca99f26d2168108861e22a66412
# TEST: ../rwsort/rwsort --plugin=flowrate.so --fields=pckts/sec ../../tests/data.rwf | ./rwgroup --plugin=flowrate.so --id-fields=pckts/sec | ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output

use strict;
use SiLKTests;

my $rwgroup = $ENV{RWGROUP} || './rwgroup';
my $rwcat = check_silk_app('rwcat');
my $rwsort = check_silk_app('rwsort');
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwsort.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwsort --plugin=flowrate.so --fields=pckts/sec $file{data} | $rwgroup --plugin=flowrate.so --id-fields=pckts/sec | $rwcat --compression-method=none --byte-order=little --ipv4-output";
my $md5 = "41554ca99f26d2168108861e22a66412";

check_md5_output($md5, $cmd);
