#! /usr/bin/perl -w
# MD5: 7abe095604b7a3e3e691308cebe0144f
# TEST: ./rwsilk2ipfix ../../tests/data.rwf | ../rwipfix/rwipfix2silk --silk-output=stdout | ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output

use strict;
use SiLKTests;

my $rwsilk2ipfix = $ENV{RWSILK2IPFIX} || './rwsilk2ipfix';
my $rwipfix2silk = check_silk_app('rwipfix2silk');
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');

exit 77 if sub { return (0 == $SiLKTests::SK_ENABLE_IPFIX); }->();

my $cmd = "$rwsilk2ipfix $file{data} | $rwipfix2silk --silk-output=stdout | $rwcat --compression-method=none --byte-order=little --ipv4-output";
my $md5 = "7abe095604b7a3e3e691308cebe0144f";

check_md5_output($md5, $cmd);
