#! /usr/bin/perl -w
# MD5: 136100bd95fd000105b0a58c92f64d3e
# TEST: ./rwsort --plugin=flowrate.so --fields=bytes/sec ../../tests/data.rwf | ../rwuniq/rwuniq --plugin=flowrate.so --fields=bytes/sec --values=bytes --presorted-input

use strict;
use SiLKTests;

my $rwsort = $ENV{RWSORT} || './rwsort';
my $rwuniq = check_silk_app('rwuniq');
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwsort.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwsort --plugin=flowrate.so --fields=bytes/sec $file{data} | $rwuniq --plugin=flowrate.so --fields=bytes/sec --values=bytes --presorted-input";
my $md5 = "136100bd95fd000105b0a58c92f64d3e";

check_md5_output($md5, $cmd);
