#! /usr/bin/perl -w
# MD5: d7afa90b95783eb94a6a9cc26c8222bd
# TEST: ./rwsort --plugin=flowrate.so --fields=pckts/sec ../../tests/data.rwf | ../rwuniq/rwuniq --plugin=flowrate.so --fields=pckts/sec --values=packets --presorted-input

use strict;
use SiLKTests;

my $rwsort = $ENV{RWSORT} || './rwsort';
my $rwuniq = check_silk_app('rwuniq');
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwsort.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwsort --plugin=flowrate.so --fields=pckts/sec $file{data} | $rwuniq --plugin=flowrate.so --fields=pckts/sec --values=packets --presorted-input";
my $md5 = "d7afa90b95783eb94a6a9cc26c8222bd";

check_md5_output($md5, $cmd);
