#! /usr/bin/perl -w
# MD5: 1aa2cff6fe6e1271f923cdcaa40cdd95
# TEST: ./rwsort --plugin=skplugin-test.so --fields=copy-bytes ../../tests/data.rwf | ../rwuniq/rwuniq --plugin=skplugin-test.so --ipv6-policy=ignore --fields=copy-bytes --values=bytes,packets,records --presorted-input

use strict;
use SiLKTests;

my $rwsort = $ENV{RWSORT} || './rwsort';
my $rwuniq = check_silk_app('rwuniq');
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwsort.' --plugin=skplugin-test.so', 'fields', qr/copy-bytes/); }->();

my $cmd = "$rwsort --plugin=skplugin-test.so --fields=copy-bytes $file{data} | $rwuniq --plugin=skplugin-test.so --ipv6-policy=ignore --fields=copy-bytes --values=bytes,packets,records --presorted-input";
my $md5 = "1aa2cff6fe6e1271f923cdcaa40cdd95";

check_md5_output($md5, $cmd);
