#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --file-ratio=800 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = $ENV{RWSPLIT} || './rwsplit';
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('byte-10M-file');
my $cmd = "$rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --file-ratio=800 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
while (<DATA>) {
    my ($i, $md5) = split " ";
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
403    e4df826a6468b288bc10ec8b7a62e99a
1309   1f3f2456f6574950adcfdcc5245e1cdb
2363   da4180e75d00bd2af9427460f81f5867
2592   7ebc622f1eaa1adf6a68ff0fb8b523bb
3549   2697e798c708cd5e4faff4b0fc325c2f
4127   a6f6a086b8603f9bc8bd471081a34633
4854   4f16ce3b66abbb5ec2a2f5039354ea41
5863   8b5ae6ffc5958c8f941b92aa192d24ef
6787   cdf707c3a349a997258c3390e41642a8
7528   2bc77f40b283d91ec0c0827fd3125c41
8792   52942cbe6dc624a2cef20e1c4fa2ae3c
9408   2fa701d4462a231c86c388056c6fa046
9761   a7121b371fc9d30e728f06ae788dab08
10752  65e87ca78d732095206750bf279cfbd4
11432  cac5607e3fb887e784b98b600ad45188
