#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --sample-ratio=1000 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = $ENV{RWSPLIT} || './rwsplit';
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('byte-10M-sample');
my $cmd = "$rwsplit --basename=$temp --byte-limit=10000000 --seed=737292 --sample-ratio=1000 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
for (my $i = 0; my $md5 = <DATA>; ++$i) {
    chomp $md5;
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
977410da528624fa6d3c1b298dc3b5b7
a95065f50b048220c230fc2859320f39
626b0e37af9a5ca15dd1499803dca123
b4347111e78f267a3cd9b2e78f7d7340
5f49fae64d543fc1aa9fa96ea6a91e07
cfccc66bdba98056d78848d50a92cadd
a8648fe76195e7436c46765233458beb
f07f19303f384315ea391cc566d8f06f
43faa089de413b8b93a3ce67e8fc40a8
521fb0680cf8c94cb237c6ac01f94f82
548028ce3245f1c462ad567f0629ffb0
cdc7989c359ab216f2bd441b8c821369
00f888d546583f432131c6af345b169c
