#! /usr/bin/perl -w
# MD5: multiple
# TEST: ./rwsplit --basename=$temp --packet-limit=50000 --seed=737292 --sample-ratio=20 --file-ratio=10 ../../tests/data.rwf && ../rwcat/rwcat --compression-method=none --byte-order=little --ipv4-output $temp*

use strict;
use SiLKTests;

my $rwsplit = $ENV{RWSPLIT} || './rwsplit';
my $rwcat = check_silk_app('rwcat');
my %file;
$file{data} = get_data_or_exit77('data');
my $temp = make_tempname('pkt-50k-sample-file');
my $cmd = "$rwsplit --basename=$temp --packet-limit=50000 --seed=737292 --sample-ratio=20 --file-ratio=10 $file{data}";

# clean up when we're done
END {
    if (!$ENV{SK_TESTS_SAVEOUTPUT}) {
        # remove files
        unlink glob($temp."*");
    }
}

if (!check_exit_status($cmd)) {
    exit 1;
}

# compute MD5 of each file
while (<DATA>) {
    my ($i, $md5) = split " ";
    my $f = sprintf("%s.%08d.rwf", $temp, $i);
    $cmd = "$rwcat --compression-method=none --byte-order=little --ipv4-output $f";
    check_md5_output($md5, $cmd);
}

__DATA__
9    755ab8ead19d64e9de02a325f9d2bb9c
14   6bb10e468edaa4cb78176cffbdebb125
23   25fe5006c2770534ee07035d9fcf1916
34   0de103f2a8b87dc1a42936835f561361
41   c32714b61bd9a593f8d61cd64f78bfcf
55   5378b0b952813c8b4358702287a8e296
65   1cbde7dff519e6831389af4f6e30a11c
73   d602426931adfeb1f59567715ab1e1a8
84   2e117c0cb4ed64858274ff825784eff8
94   6451b0a487d1d31fa7102a1143e1afb2
104  4eeeef77a6f738b9278c820afd2036f3
119  f4e6e680c077a7a330dee4662b5176d6
125  2b250ffa2378b6adf5ed2c71a49a9a2a
134  d73430122f99138fc823a53197c15ef4
