#! /usr/bin/perl -w
# MD5: 16b346acb4f5ada6f26e738bb88231be
# TEST: ./rwstats --fields=dip --values=packets --threshold=25000 --top ../../tests/data-v6.rwf

use strict;
use SiLKTests;

my $rwstats = $ENV{RWSTATS} || './rwstats';
my %file;
$file{v6data} = get_data_or_exit77('v6data');

exit 77 if sub { return (1 != $SiLKTests::SK_ENABLE_IPV6); }->();

my $cmd = "$rwstats --fields=dip --values=packets --threshold=25000 --top $file{v6data}";
my $md5 = "16b346acb4f5ada6f26e738bb88231be";

check_md5_output($md5, $cmd);
