#! /usr/bin/perl -w
# MD5: 136100bd95fd000105b0a58c92f64d3e
# TEST: ./rwuniq --plugin=flowrate.so --fields=bytes/sec --values=bytes --sort-output ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwuniq = $ENV{RWUNIQ} || './rwuniq';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwuniq.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwuniq --plugin=flowrate.so --fields=bytes/sec --values=bytes --sort-output $file{data}";
my $md5 = "136100bd95fd000105b0a58c92f64d3e";

check_md5_output($md5, $cmd);
