#! /usr/bin/perl -w
# MD5: d7afa90b95783eb94a6a9cc26c8222bd
# TEST: ./rwuniq --plugin=flowrate.so --fields=pckts/sec --values=packets --sort-output ../../tests/data.rwf

use strict;
use SiLKTests;

my $rwuniq = $ENV{RWUNIQ} || './rwuniq';
my %file;
$file{data} = get_data_or_exit77('data');
add_plugin_dirs('/src/plugins');

exit 77 if sub { return 1 != check_app_switch($rwuniq.' --plugin=flowrate.so', 'fields', qr/payload-rate/); }->();

my $cmd = "$rwuniq --plugin=flowrate.so --fields=pckts/sec --values=packets --sort-output $file{data}";
my $md5 = "d7afa90b95783eb94a6a9cc26c8222bd";

check_md5_output($md5, $cmd);
